package com.junmp.jyzb.doc;

import com.junmp.jyzb.api.bean.dto.ProductBatchDto;
import com.junmp.jyzb.api.bean.dto.ProductProcessDto;
import com.junmp.jyzb.api.bean.query.ProductBatchReq;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 18:12
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Api(value = "生产管理", tags = "生产管理接口")
public interface ProductBatchDoc {

    /**
     * 生产标签
     *
     * @param req
     */
    @ApiOperation(value = "生产初始化", tags = "生产管理接口")
    ApiRes<Boolean> makeProduct(ProductBatchReq req);


    /**
     * 新增批次信息
     */
    @ApiOperation(value = "新增批次信息", tags = "生产管理接口")
    ApiRes<Boolean> addProductBatch(ProductBatchReq req);

    /**
     * 更新批次信息
     */
    @ApiOperation(value = "更新批次信息", tags = "生产管理接口")
    ApiRes<Boolean> editProductBatch(ProductBatchReq req);

    /**
     * 删除批次信息
     */
    @ApiOperation(value = "删除批次信息", tags = "生产管理接口")
    ApiRes<Boolean> delBatch(ProductBatchReq req);

    /**
     * 分页批次信息
     */
    @ApiOperation(value = "分页批次信息", tags = "生产管理接口")
    ApiRes<PageResult<ProductBatchDto>> getPage(ProductBatchReq req);

    /**
     * 分页批次信息
     */
    @ApiOperation(value = "分页批次进度信息", tags = "生产管理接口")
    ApiRes<PageResult<ProductProcessDto>> getProcessPage(ProductBatchReq req);
}
