package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.dto.OrgTreeDto;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/PubOrg")
@Api(tags = "组织机构模块")
public class PubOrgController {
    @Resource
    public PubOrgService pubOrgService;

    @GetMapping("/SetOrgParentIds")
    @ApiOperation("填充组织机构的parent_ids字段")
    public ResponseResult setOrgParentIds() {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setOrgParentIds();
        return returnMsg;
    }

    @PostMapping("/SetDName")
    @ApiOperation("填充组织机构简称到数据库")
    public ResponseResult setShortName(@RequestBody Map<String, Object> orgId) {
        ResponseResult returnMsg = pubOrgService.setShortName(orgId);
        return returnMsg;
    }

    @PostMapping("/GetOrgList")
    @ApiOperation("查询组织树形结构")
    public ApiRes<List<OrgTreeDto>> getOrgList(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getOrgList(req));
    }
    @PostMapping("/GetLowOrg")
    @ApiOperation("根据组织机构查询下一级信息")
    public ApiRes<List<OrgDto>> getLowOrg(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getLowOrg(req)) ;
    }
}
