package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Equipment")
@Api(tags = "物资基础信息模块")
public class EquipmentTypeController {
    @Resource
    public EquipmentTypeService equipmentTypeService;

    @PostMapping("/AddEquipment")
    @ApiOperation("添加物资")
    public ApiRes<Boolean> addEquipment(@RequestBody @Validated(ValidationApi.add.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.addEquipment(req));
    }


    @PostMapping("/DeleteEquipment")
    @ApiOperation("删除装备信息")
    public ApiRes<Boolean> deleteEquipment(@RequestBody @Validated(ValidationApi.delete.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.deleteEquipment(req));
    }

    @PostMapping("/ChangeEquipmentState")
    @ApiOperation("禁用/启用装备类型")
    public ApiRes<Boolean> changeEquipmentState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.changeEquipmentState(req));
    }

    @PostMapping("/ShowEquipmentList")
    @ApiOperation("查询类别列表")
    public ApiRes<List<EquipmentTreeDto>> ShowEquipmentList(@RequestBody QueryEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.getEquipmentList(req));
    }


    @PostMapping("/GetEquipmentDetail")
    @ApiOperation("查询单个物资信息")
    public ApiRes<EquipmentTypeDto> getEquipment(@RequestBody QueryEquipmentTypeReq req) {
        return ApiRes.success( equipmentTypeService.getEquipment(req));
    }

    @PostMapping("/UpdateEquipment")
    @ApiOperation("修改物资信息")
    public ApiRes<Boolean> updateEquipment(@RequestBody @Validated(ValidationApi.edit.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.updateEquipment(req));
    }


    @PostMapping("/SetTypeParentIds")
    @ApiOperation("填充装备类型的parent_ids字段")
    public ResponseResult setTypeParentIds() {
        ResponseResult returnMsg = equipmentTypeService.setTypeParentIds();
        return returnMsg;
    }

}
