package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.ProductBatchDto;
import com.junmp.jyzb.api.bean.dto.ProductProcessDto;
import com.junmp.jyzb.api.bean.req.ProductBatchReq;
import com.junmp.jyzb.entity.ProductBatch;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/30 13:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface ProductBatchService extends IService<ProductBatch> {

    /**
     * 新增
     *
     * @param req
     */
    boolean addProductBatch(ProductBatchReq req);

    /**
     * 编辑
     *
     * @param req
     */
    boolean editProductBatch(ProductBatchReq req);

    /**
     * 删除
     *
     * @param req
     */
    boolean del(ProductBatchReq req);

    /**
     * 列表信息
     *
     * @param req
     */
    List<ProductBatch> findList(ProductBatchReq req);

    /**
     * 分页信息
     *
     * @param req
     */
    PageResult<ProductBatchDto> findPage(ProductBatchReq req);


    /**
     * 分页信息
     *
     * @param req
     */
    PageResult<ProductProcessDto> findProcessPage(ProductBatchReq req);

    /**
     * 获取批次详细信息
     *
     * @param batchId
     */
    ProductBatchDto getBatchDetail(Long batchId);
}
