package com.junmp.jyzb.domain;

import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-Policeman")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Policeman implements Serializable {
    /**
    * 警员id
    */
    @ApiModelProperty(value="警员id")
    private String id;

    /**
    * 警员名称
    */
    @ApiModelProperty(value="警员名称")
    private String name;

    /**
    * 单警柜关联id
    */
    @ApiModelProperty(value="单警柜关联id")
    private String cabinetId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value="组织机构名称")
    private Cabinet cabinetName;

    /**
    * 机构代码，一个警员只属于一个机构
    */
    @ApiModelProperty(value="机构代码，一个警员只属于一个机构")
    private String orgId;

    /**
     * 机构名称
     */
    @ApiModelProperty(value="机构名称")
    private PubOrg orgName;

    /**
    * 警员编号
    */
    @ApiModelProperty(value="警员编号")
    private String policeCode;

    /**
    * 警员性别
    */
    @ApiModelProperty(value="警员性别")
    private String sex;

    /**
     * 人脸信息
     */
    @ApiModelProperty(value="人脸信息")
    private String faceInfo;

    /**
     * 是否已生成对应账号，1表生成，0表未生成
     */
    @ApiModelProperty(value="是否已生成对应账号，1表生成，0表未生成")
    private Integer isCreatedAccount;

    /**
     * 门禁编码
     */
    @ApiModelProperty(value="门禁编码")
    private String doorCode;

    /**
     * 密码
     */
    @ApiModelProperty(value="密码")
    private String password;

    /**
    * 警员照片
    */
    @ApiModelProperty(value="警员照片")
    private String photo;

    /**
    * 联系方式
    */
    @ApiModelProperty(value="联系方式")
    private String phone;

    /**
    * 创建时间
    */
    @ApiModelProperty(value="创建时间")
    private Date createTime;

    /**
    * 最后更新时间
    */
    @ApiModelProperty(value="最后更新时间")
    private Date updateTime;

    /**
     * 身份证信息
     */
    @ApiModelProperty(value="身份证信息")
    private String idCard;

    /**
    * 更新人员
    */
    @ApiModelProperty(value="更新人员")
    private String updateUser;

    /**
     * 警员状态
     */
    @ApiModelProperty(value="警员状态")
    private Integer state;

    /**
     * 指纹信息
     * */
    private List<Map<String, Object>> fingerMsg;

    /**
     * 警员状态
     */
    @ApiModelProperty(value="指纹id")
    private Integer fingerId;

    /**
     * 指纹名称
     */
    @ApiModelProperty(value="指纹名称")
    private String fingerName;

    /**
     * 指纹信息
     */
    @ApiModelProperty(value="指纹信息")
    private String fingerInfo;

    /**
     * 单警柜关联箱号id
     * */
    private String cabinetBoxId;

    private static final long serialVersionUID = 1L;
}