package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-InventorySummary")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InventorySummary implements Serializable {
    /**
     * 装备汇总id
     */
    @ApiModelProperty(value = "装备汇总id")
    private String id;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    private String orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String orgName;

    /**
     * 装备类型id
     */
    @ApiModelProperty(value = "装备类型id")
    private String typeId;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称")
    private String typeName;

    /**
     * 装备号型id
     */
    @ApiModelProperty(value = "装备号型id")
    private String sizeId;

    /**
     * 号型名称
     */
    @ApiModelProperty(value = "号型名称")
    private String sizeName;

    /**
     * 位置类型，0代表仓库，1代表单警柜
     */
    @ApiModelProperty(value = "位置类型，0代表仓库，1代表单警柜")
    private String locationType;

    /**
     * 位置信息id
     */
    @ApiModelProperty(value = "位置信息id")
    private String locationId;

    /**
     * 位置名称
     */
    @ApiModelProperty(value = "位置名称")
    private String locationName;

    /**
     * 区域id
     */
    @ApiModelProperty(value = "区域id")
    private String locationAreaId;

    /**
     * 区域信息
     */
    @ApiModelProperty(value = "区域信息")
    private String locationArea;

    /**
     * 库存数量
     */
    @ApiModelProperty(value = "库存数量")
    private Integer number;

    /**
     * 总价
     */
    @ApiModelProperty(value = "总价")
    private BigDecimal price;

    /**
     * 在库数
     */
    @ApiModelProperty(value = "在库数")
    private Integer stockNumber;

    /**
     * 出库数量
     */
    @ApiModelProperty(value = "出库数量")
    private Integer outboundNumber;

    /**
     * 销毁数量
     */
    @ApiModelProperty(value = "销毁数量")
    private Integer destructionNumber;

    /**
     * 过质保数量
     */
    @ApiModelProperty(value = "过质保数量")
    private Integer expireNumber;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}