package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-History")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class History implements Serializable {
    /**
     * 历史记录id
     */
    @ApiModelProperty(value = "历史记录id")
    private String id;

    /**
     * 装备类型id
     */
    @ApiModelProperty(value = "装备类型id")
    private String equipmentId;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    private String organizationId;

    /**
     * 要查询的时间
     */
    @ApiModelProperty(value = "要查询的时间")
    private Date searchDate;

    /**
     * 当月使用次数
     */
    @ApiModelProperty(value = "当月使用次数")
    private Integer useMonth;

    /**
     * 当月维修次数
     */
    @ApiModelProperty(value = "当月维修次数")
    private Integer fixMonth;

    private static final long serialVersionUID = 1L;
}