package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.SupplierService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.RequestParam;
import com.junmp.jyzb.utils.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Supplier")
@Api(tags = "供应商基础信息模块")
public class SupplierController {
    @Resource
    public SupplierService supplierService;

    @PostMapping("/AddSupplier")
    @ApiOperation("添加供应商")
    public ResponseResult addSupplier(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = supplierService.addSupplier(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteSupplier")
    @ApiOperation("删除供应商信息")
    public ResponseResult deleteSupplier(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = supplierService.deleteSupplier(msg);
        return returnMsg;
    }

    @PostMapping("/ShowSupplier")
    @ApiOperation("查询供应商列表")
    public ResponseResult getAllSupplier(@RequestBody Map<String,Object> msg){
        ResponseResult returnMsg = supplierService.getAllSupplier(msg);
        return  returnMsg;
    }

//    @PostMapping("/GetOneSupplier")
//    @ApiOperation("查询单个供应商信息")
//    public ResponseResult getOneSupplier(@RequestBody Map<String, Object> msg) {
//        String supplierId = msg.get("supplierId").toString();
//        Map<String, Object> supplierMsg = supplierService.getOneSupplier(supplierId);
//        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",supplierMsg);
//    }

    @PostMapping("/UpdateSupplier")
    @ApiOperation("修改供应商信息")
    public ResponseResult updateSupplier(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = supplierService.updateSupplier(msg);
        return returnMsg;
    }

    @PostMapping("/ChangeSupplierState")
    @ApiOperation("修改警员状态")
    public ResponseResult changeSupplierState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = supplierService.changeSupplierState(msg);
        return returnMsg;
    }
}
