package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 18:28
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ProductSkuReq extends BaseRequest {

    @NotNull(message = "号型主键不能为空", groups = {edit.class, delete.class, detail.class})
    private Long specId;


    private String skuCode ;

    /**
     * 号型
     */
    private String spec;

    /**
     * 重量
     */
    private String weight;

    /**
     * 材质
     */
    private String material;


    /**
     * 关联产品
     */
    private Long productId;

    /**
     * 预览属性1
     */
    private String attr1;

    /**
     * 预览属性2
     */
    private String attr2;

    /**
     * 预览属性3
     */
    private String attr3;
}
