package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;


@TableName(value ="bussiness_inventory_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class InventoryDetail implements Serializable {
    /**
     * id
     */
    @TableId(value = "id")
    @Id
    private Long id;

    /**
     * 盘点表主键
     */
    @TableField(value = "inventory_id")
    private Long inventoryId;

    /**
     * 装备类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 装备类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 装备号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 装备号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 在库数（包含报废区）
     */
    @TableField(value = "stock_number")
    private Integer stockNumber;

    /**
     * 修正后的在库数量
     */
    @TableField(value = "fix_number")
    private Integer fixNumber;
    /**
     * 差距数量
     */
    @TableField(value = "num")
    private Integer num;

    /**
     * 状态.0正常，1盈余，2亏损
     */
    @TableField(value = "state")
    private Integer state;


    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;



    private static final long serialVersionUID = 1L;

}
