package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.DestoryUnitReq;
import com.junmp.jyzb.api.bean.req.RepairUnitReq;
import com.junmp.jyzb.entity.DestoryUnit;
import com.junmp.jyzb.entity.RepairUnit;
import com.junmp.jyzb.service.RepairUnitService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@Api(tags = "[业务]维修单位模块")
@RequestMapping("/RepairUnit")
public class RepairUnitController {
    @Resource
    private RepairUnitService repairUnitService;

    //创建报废/销毁单位
    @PostMapping("/AddRepairUnit")
    @ApiOperation("创建报废/销毁单位")
    public ApiRes<String> addRepairUnit(@RequestBody @Validated(ValidationApi.add.class) RepairUnitReq req){
        return ApiRes.success(repairUnitService.addRepairUnit(req));
    }

    //修改报废/销毁单位
    @PostMapping("/UpdateRepairUnit")
    @ApiOperation("修改报废/销毁单位")
    public ApiRes<Boolean> updateRepairUnit(@RequestBody @Validated(ValidationApi.edit.class) RepairUnitReq req){
        return ApiRes.success(repairUnitService.updateRepairUnit(req));
    }

    //查询报废/销毁单位(list)
    @PostMapping("/ShowRepairUnitList")
    @ApiOperation("查询报废/销毁单位(list)")
    public ApiRes<List<RepairUnit>> showRepairUnitList(@RequestBody RepairUnitReq req){
        return ApiRes.success(repairUnitService.showRepairUnitList(req));
    }

    //查询报废/销毁单位(page)
    @PostMapping("/ShowRepairUnitPage")
    @ApiOperation("修改报废/销毁单位(page)")
    public ApiRes<PageResult<RepairUnit>> showRepairUnitPage(@RequestBody RepairUnitReq req){
        return ApiRes.success(repairUnitService.showRepairUnitPage(req));
    }
    //删除报废/销毁单位
    @PostMapping("/DelRepairUnit")
    @ApiOperation("修改报废/销毁单位")
    public ApiRes<Boolean> delRepairUnit(@RequestBody RepairUnitReq req){
        return ApiRes.success(repairUnitService.delRepairUnit(req));
    }
}
