package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UpdatePoliceFingerReq extends BaseRequest {
    /**
     * 指纹id
     */
    @NotNull(message = "指纹id不能为空",groups = {delete.class,edit.class})
    @ApiModelProperty(value = "指纹id")
    private Integer id;

    /**
     * 警员id
     */
    @NotBlank(message = "警员id不能为空",groups = {add.class, delete.class,edit.class})
    @ApiModelProperty(value = "警员id")
    private String policeId;

    /**
     * 指纹名称
     */
    @NotBlank(message = "指纹名称不能为空",groups = {add.class})
    @ApiModelProperty(value = "指纹名称")
    private String name;

    /**
     * 指纹信息
     */
    @NotBlank(message = "指纹信息不能为空",groups = {add.class, edit.class})
    @ApiModelProperty(value = "指纹信息")
    private String fingerInfo;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
