package com.junmp.junmpProcess.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.junmp.junmpProcess.common.utils.HttpStatus;
import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.common.utils.ReturnMsg;
import com.junmp.junmpProcess.dto.*;
import com.junmp.junmpProcess.entity.ProcessTemplates;
import com.junmp.junmpProcess.service.Repository.ProcessTemplateService;
import com.junmp.junmpProcess.vo.*;
import com.junmp.jyzb.api.bean.query.ProcessReq.FormReq;
import com.junmp.jyzb.api.bean.query.ProcessReq.SuspendOrActivateDefinitionReq;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.junmp.junmpProcess.service.Bussiness.WorkProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@Slf4j
@RestController
@RequestMapping("/Process")
@Api(tags = "流程表单方法")
public class BpmnController  {

    @Autowired
    private ProcessTemplateService processTemplateService;
    @Autowired
    private WorkProcessService WorkProcessService;

    @ApiOperation("创建流程和表单")
    @PostMapping(value = "create")

    public ApiRes<Boolean> create(@RequestBody ProcessVO processVO) throws JsonProcessingException {
        return ApiRes.success(WorkProcessService.createBpmn(processVO));

    }
    /**
     * 修改表单
     */
    @ApiOperation("修改表单")
    @PostMapping("updateForm")
    public ApiRes<Boolean> updateForm(@RequestBody UpdateProcessVO process) throws JsonProcessingException {
        return ApiRes.success(WorkProcessService.updateForm(process));
    }
    /**
     * 删除流程实例
     */
    @ApiOperation("删除流程实例")
    @PostMapping("deleteForm")
    public ApiRes<Boolean> deleteProcessInstanceById(@RequestBody ProcessDTO process)  {
        return ApiRes.success(WorkProcessService.deleteProcessInstance(process));
    }
    /**
     * 修改表单名称和备注
     */
    @ApiOperation("修改表单名称和备注")
    @PostMapping("updateFormName")
    public ApiRes<Boolean> updateFormName(@RequestBody UpdateProcessVO process) throws JsonProcessingException {
        return  ApiRes.success(WorkProcessService.updateFormName(process));
    }

    /**
     * 转交
     */
    @ApiOperation("转交")
    @PutMapping("turn")
    public ApiRes<Boolean> turn(@RequestBody TurnVo turns) {
        if (WorkProcessService.turn(turns))
        {
            return ApiRes.success();
        }
        else
        {
            return ApiRes.failure("沒有可用实例");
        }

    }
    @ApiOperation("创建新表单")
    @PostMapping("createForm")
    public ApiRes<String> createForm(@RequestBody FormReq formReq) {
        return ApiRes.success(WorkProcessService.createNewForm(formReq));
    }
    @ApiOperation("终止流程")
    @PostMapping("StopProcessInstanceById")
    public ApiRes<Boolean> stopProcessInstanceById(@RequestBody HandleDataDTO handleDataDTO) {
        return WorkProcessService.stopProcessInstanceById(handleDataDTO);
    }
    @ApiOperation("挂起流程实例")
    @PostMapping("SuspendOrActivateDefinition")
    public ApiRes<Boolean> SuspendOrActivateDefinition(@RequestBody SuspendOrActivateDefinitionReq req) {
        return ApiRes.success(WorkProcessService.suspendOrActivateProcessDefinitionById(req));
    }
    @ApiOperation("通过流程定义id启动流程")
    @PostMapping("start")
    public ApiRes<String> start(@RequestBody StartProcessInstanceDTO startProcessInstanceDTO) {

        return ApiRes.success(WorkProcessService.start(startProcessInstanceDTO));
    }
    @ApiOperation("通过流程实例查看审批记录")
    @PostMapping("record")
    public ApiRes<List<TaskDetailVO>> record(@RequestBody HandleDataDTO handleDataDTO) {

        return WorkProcessService.record(handleDataDTO.getProcessInstanceId());
    }
    @ApiOperation("通过流程定义查看详情")
    @PostMapping("instanceInfo")
    public ApiRes<HandleDataVO> instanceInfo(@RequestBody HandleDataDTO handleDataDTO) {
        return WorkProcessService.instanceInfo(handleDataDTO);
    }
    @ApiOperation("查看我发起的流程")
    @PostMapping("applyList")
    public ApiRes<PageResult<HistoryProcessInstanceVO>> applyList(@RequestBody ApplyDTO ApplyDTO) {
        return ApiRes.success(WorkProcessService.applyList(ApplyDTO));
    }
    @ApiOperation("根据业务ID换取最新的流程信息")
    @PostMapping("getProcessDefinitionId")
    public ApiRes<String> getProcessDefinitionId(@RequestBody Map<String,Object> templateId) {
        String temp= templateId.get("formId").toString();
        return WorkProcessService.getProcessDefinitionId(temp);
    }
    @ApiOperation("查看我的待办")
    @PostMapping("toDoList")
    public ApiRes<PageResult<TaskVO>> toDoList(@RequestBody TaskDTO taskDTO){
        return ApiRes.success(WorkProcessService.toDoList(taskDTO));
    }
    @ApiOperation("同意按钮")
    @PostMapping("agree")
    public ResponseResult agree(@RequestBody HandleDataDTO handleDataDTO){
        return WorkProcessService.agree(handleDataDTO);
    }
    @ApiOperation("查看我的已办")
    @PostMapping("")
    public ApiRes<PageResult<TaskVO>> doneList(@RequestBody TaskDTO taskDTO){
        return ApiRes.success(WorkProcessService.doneList(taskDTO));
    }
    @ApiOperation("撤销按钮")
    @PostMapping("revoke")
    public ResponseResult revoke(@RequestBody HandleDataDTO handleDataDTO){
        return WorkProcessService.revoke(handleDataDTO);
    }

    @ApiOperation("拒绝按钮")
    @PostMapping("refuse")
    public ResponseResult refuse(@RequestBody HandleDataDTO handleDataDTO){
        return WorkProcessService.refuse(handleDataDTO);
    }
    /**
     * 查询表单模板数据
     *
     * @param templateId 模板id
     * @return 模板详情数据
     */
    @ApiOperation("根据ID获取表单信息")
    @PostMapping(value = "getFormTemplateById")
    public ResponseResult  getFormTemplateById(@RequestBody Map<String,Object> templateId) {
        String temp= templateId.get("templateId").toString();
        ProcessTemplates processTemplates = processTemplateService.getById(temp);
        processTemplates.setFormId(processTemplates.getTemplateId());
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,processTemplates);
    }

    @ApiOperation("获取全部可用的表单和审核流")
    @GetMapping(value = "getFormList")
    public ApiRes<PageResult<TemplateGroupVo>> getFormList(BaseRequest br) {
        return ApiRes.success(WorkProcessService.getFormList(br));
    }



}
