package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;


//警员调岗
@Data
@EqualsAndHashCode(callSuper = true)
public class QueryReassignmentReq extends BaseRequest {
    /**
     * id
     */
    private String id;

    /**
     * 经办人
     */
    private String agent;

    /**
     * 工作流定义id
     */
    private String processDefinitionId;
    //实例id
    private String processId;

    private String orderCode;

    /**
     * 调岗警员id
     */
    private String policeId;

    /**
     * 调岗警员姓名
     */
    private String policeName;

    /**
     * 警员带走装备
     */
    private String detailList;

    private String invList;


    /**
     * 组织机构id（警员原组织机构id）
     */
    private Long orgId;

    private String orgName;

    /**
     * 警员编号
     */
    private String policeCode;

    /**
     * 调岗原因
     */
    private String note;

    /**
     * 审核状态(none未接入工作流，working审批中，finished审批完成)
     */
    private String examineState;
    /**
     * 申请时间
     */
    private Date applyTime;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 排序规则
     */
    private String order;
    /**
     * 排序字段
     */
    private String column;

    /**
     * 装备总数
     */
    private Integer totalNum;
    /**
     * 装备总金额
     */
    private BigDecimal price;
    /**
     * 类型（调入警员0，调出警员1）
     */
    private String reassignmentType;

    //登录人id
    private String userId;

    private String typeName;
    private String sizeName;
    private String sizeId;
    private String typeId;


}
