package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 警员调岗申请单
 * @TableName bussiness_reassignment
 */
@TableName(value ="bussiness_reassignment")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class Reassignment implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 工作流id
     */
    @TableField(value = "process_id")
    private String processId;

    /**
     * 订单编号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 调岗警员id
     */
    @TableField(value = "police_id")
    private String policeId;

    /**
     * 调岗警员姓名
     */
    @TableField(value = "police_name")
    private String policeName;

    /**
     * 警员带走装备
     */
    @TableField(value = "detail_list")
    private String detailList;

    /**
     * 警员带走装备
     */
    @TableField(value = "inv_list")
    private String invList;

    /**
     * 组织机构id（谁申请，就是谁的组织机构号）
     */
    @TableField(value = "org_id")
    private Long orgId;

    @TableField(value = "org_name")
    private String orgName;

    /**
     * 警员
     */
    @TableField(value = "police_code")
    private String policeCode;

    /**
     * 调岗原因
     */
    @TableField(value = "note")
    private String note;

    /**
     * 审核状态(none未接入工作流，working审批中，finished审批完成)
     */
    @TableField(value = "examine_state")
    private String examineState;

    /**
     * 当前审核人
     */
    @TableField(value = "current_assign")
    private String currentAssign;

    /**
     * 历史审核人
     */
    @TableField(value = "history_assign")
    private String historyAssign;
    /**
     * 经办人
     */
    @TableField(value = "agent")
    private String agent;
    /**
     * 经办人
     */
    @TableField(value = "agent_id")
    private String agentId;
    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;
    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 装备总数
     */
    @TableField(value = "total_num")
    private Integer totalNum;
    /**
     * 装备总金额
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 类型（调入警员0，调出警员1）
     */
    @TableField(value = "reassignment_type")
    private String reassignmentType;





    private static final long serialVersionUID = 1L;

}