package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_order
 */
@TableName(value ="bussiness_handover")
@Data
public class Handover implements Serializable {
    /**
     * 单子id
     */
    private String id;

    /**
     * 工作流id
     */
    @TableField("process_id")
    private String processId;

    /**
     * 单据类型（个人装备的移交handOver，报废broken，维修fix）
     */
    @TableField("bussiness_type")
    private String bussinessType;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    private Date applyTime;

    /**
     * 申请人
     */
    @TableField("applicant_id")
    private String applicantId;

    /**
     * 接收人
     */
    @TableField("recipient_id")
    private String recipientId;

    /**
     * 申请理由
     */
    @TableField("apply_reason")
    private String applyReason;

    /**
     * 仓库id
     */
    @TableField("location_id")
    private String locationId;

    /**
     * 总数量
     */
    @TableField("total_num")
    private Integer totalNum;

    /**
     * 总价格
     */
    private BigDecimal price;

    /**
     * 审核状态:none,未接入审核流，working审批中，finished
     */
    @TableField("examine_state")
    private String examineState;

    /**
     * 申请人组织机构id
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField("create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField("update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;


}