package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.UserDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.WarehouseInfoDto;
import com.junmp.jyzb.api.bean.query.PolicemanReq;
import com.junmp.jyzb.api.bean.query.ShelfReq;
import com.junmp.jyzb.api.bean.query.WarehouseAreaReq;
import com.junmp.jyzb.api.bean.query.WarehouseReq;
import com.junmp.jyzb.api.bean.req.OpenDoorReq;
import com.junmp.jyzb.api.bean.req.UpdateShelfReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseAreaReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseReq;
import com.junmp.jyzb.api.util.WsWarehouseReq;
import com.junmp.jyzb.cache.TemperatureRedisCache;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.entity.Temp.HumidityAndtemperature;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Warehouse")
@Api(tags = "[基础信息]仓库基础信息模块")
public class WarehouseController {
    @Resource
    public WarehouseService warehouseService;

    @Resource
    public WarehouseAreaService warehouseAreaService;

    @Resource
    public ShelfService shelfService;


    @PostMapping(path="/OpenDoor",name="远程开门#logType=30")
    @ApiOperation("远程开门")
    public ApiRes<String> OpenDoor(@RequestBody @Validated(ValidationApi.add.class) OpenDoorReq req) {
        return ApiRes.success(warehouseService.OpenDoor(req));
    }

    @PostMapping(path="/AddWarehouse",name="添加仓库#logType=30")
    @ApiOperation("添加仓库")
    public ApiRes<String> AddWarehouse(@RequestBody @Validated(ValidationApi.add.class) UpdateWarehouseReq req) {
        return ApiRes.success(warehouseService.AddWarehouse(req));
    }

    @PostMapping(path="/CheckState",name="查询仓库设备状态")
    @ApiOperation("查询仓库设备状态")
    public ApiRes<WsWarehouseReq> CheckState(@RequestBody @Validated(ValidationApi.add.class) WarehouseReq req) {
        return ApiRes.success(warehouseService.CheckState(req));
    }

    @PostMapping(path="/DeleteWarehouse",name="删除仓库信息#logType=30")
    @ApiOperation("删除仓库信息")
    public ApiRes<Boolean> DeleteWarehouse(@RequestBody UpdateWarehouseReq req) {
        return ApiRes.success(warehouseService.DeleteWarehouse(req));
    }


    @PostMapping(path="/ChangeWarehouseState",name="禁用/启用仓库#logType=30")
    @ApiOperation("禁用/启用仓库")
    public ApiRes<Boolean> changeWarehouseState(@RequestBody @Validated(ValidationApi.updateStatus.class) WarehouseReq req) {
        return ApiRes.success(warehouseService.changeWarehouseState(req));
    }

    /**
     * 通过组织机构id获取仓库列表
     * @param req
     * @return
     */

    @PostMapping(path="/ShowWarehouse",name="查询仓库列表#enable")
    @ApiOperation("查询仓库列表")
    public ApiRes<List<WarehouseDto>> getAllWarehouse(@RequestBody @Validated(ValidationApi.edit.class) WarehouseReq req){
        return ApiRes.success(warehouseService.getAllWarehouse(req.getOrgId(),req.getState()));
    }

    //通过仓库id查询列表

    @PostMapping(path="/GetWarehouseDetail",name="查询单个仓库信息#enable")
    @ApiOperation("查询单个仓库信息")
    public ApiRes<WarehouseDto> getOneWarehouse(@RequestBody @Validated(WarehouseReq.detail.class)WarehouseReq req) {
        return ApiRes.success(warehouseService.getOneWarehouse(req));
    }


    @PostMapping(path="/UpdateWarehouse",name="修改仓库信息#logType=30")
    @ApiOperation("修改仓库信息")
    public ApiRes<Boolean> updateWarehouse(@RequestBody @Validated(ValidationApi.edit.class) UpdateWarehouseReq req) {
        return ApiRes.success(warehouseService.updateWarehouse(req));
    }

    @PostMapping(path="/AddArea",name="添加区域#logType=30")
    @ApiOperation("添加区域")
    public ApiRes<String> addArea(@RequestBody @Validated(ValidationApi.add.class) UpdateWarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.addArea(req));
    }

    @PostMapping(path="/UpdateArea",name="修改区域#logType=30")
    @ApiOperation("修改区域")
    public ApiRes<Boolean> updateArea(@RequestBody @Validated(ValidationApi.edit.class) UpdateWarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.updateArea(req));
    }


    @PostMapping(path="/DeleteArea",name="删除区域#logType=30")
    @ApiOperation("删除区域")
    public ApiRes<Boolean> deleteArea(@RequestBody @Validated(ValidationApi.delete.class) UpdateWarehouseAreaReq req) {
        return ApiRes.success(warehouseAreaService.deleteArea(req));
    }


    @PostMapping(path="/GetAreaList",name="查询区域信息#enable")
    @ApiOperation("查询区域信息")
    public ApiRes<List<WarehouseAreaDto>> getAreaList(@RequestBody @Validated(ValidationApi.detail.class) WarehouseAreaReq req){
        return ApiRes.success(warehouseAreaService.getAreaList(req));
    }


    @PostMapping(path="/AddShelf",name="添加货架#logType=30")
    @ApiOperation("添加货架")
    public ApiRes<String> AddShelf(@RequestBody @Validated(ValidationApi.add.class) UpdateShelfReq req) {
        return ApiRes.success(shelfService.AddShelf(req));
    }

    @PostMapping(path="/UpdateShelf",name="修改货架#logType=30")
    @ApiOperation("修改货架")
    public ApiRes<Boolean> UpdateShelf(@RequestBody @Validated(ValidationApi.edit.class) UpdateShelfReq req) {
        return ApiRes.success(shelfService.UpdateShelf(req));
    }

    @PostMapping(path="/DeleteShelf",name="删除货架#logType=30")
    @ApiOperation("删除货架")
    public ApiRes<Boolean> DeleteShelf(@RequestBody @Validated(ShelfReq.delete.class) UpdateShelfReq req) {
        return ApiRes.success(shelfService.DeleteShelf(req));
    }


    @PostMapping(path="/GetShelfList",name="查询货架信息#enable")
    @ApiOperation("查询货架信息")
    public ApiRes<List<ShelfDto>> GetShelfList(@RequestBody @Validated(ValidationApi.detail.class) ShelfReq req){
        return ApiRes.success(shelfService.GetShelfList(req));
    }

    @PostMapping(path="/alignWarehouseInfo",name="同步更新仓库信息#enable")
    @ApiOperation("同步更新仓库信息")
    public ApiRes<List<WarehouseInfoDto>> alignWarehouseInfo(@RequestBody UpdateWarehouseReq req){
        return ApiRes.success(warehouseService.alignWarehouseInfo(req));
    }

    @PostMapping(path="/updateHumidityAndtemperature",name="更新温湿度#logType=30")
    @ApiOperation("更新温湿度")
    public ApiRes<Boolean> updateHumidityAndtemperature(@RequestBody HumidityAndtemperature req){
        return ApiRes.success(warehouseService.updateHumidityAndtemperature(req));
    }



}
