package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum ProcessExceptionEnum implements IExceptionEnum {
    /**
     * 流程不存在
     */
    PROCESS_ISNOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"设计流程不存在，请先设计流程");

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    ProcessExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
