package com.junmp.jyzb.mapper;

import com.junmp.jyzb.api.bean.dto.LargeScreenDto.AreaDto;
import com.junmp.jyzb.api.bean.dto.LargeScreenDto.GroupByCountDto;
import com.junmp.jyzb.api.bean.dto.LargeScreenDto.Top5Dto;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgCountDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgCountDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOutAndInDto;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgCountReq;
import com.junmp.jyzb.entity.EquipmentCountSummary;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【vie_equipment_count_summary】的数据库操作Mapper
* @createDate 2023-12-14 14:41:35
* @Entity com.junmp.jyzb.entity.EquipmentCountSummary
*/
public interface EquipmentCountSummaryMapper extends BaseMapper<EquipmentCountSummary> {



     TjOrgCountDto TjOrgCount(@Param("orgId") String orgId,
                             @Param("typeIdsList") List<String> typeIdsList,
                             @Param("sizeNameList") List<String> sizeNameList,
                             @Param("year")Integer year,
                             @Param("typeParentId")String typeParentId,
                             @Param("monthList") List<Integer> monthList);
//    List<TjOrgCountDto>  TjOrgCount1(@Param("orgId") String orgId,
//                                    @Param("typeIdsList") List<String> typeIdsList,
//                                    @Param("sizeNameList") List<String> sizeNameList,
//                                    @Param("year")Integer year,
//                                    @Param("typeParentId")String typeParentId,
//                                    @Param("monthList") List<Integer> monthList);
    TjOrgCountDto TjOrgCountleve4(@Param("orgId") Long orgId,
                                  @Param("typeIdsList") List<String> typeIdsList,
                                  @Param("sizeNameList") List<String> sizeNameList,
                                  @Param("year") Integer year,
                                  @Param("typeParentId")String typeParentId,
                                  @Param("monthList") List<Integer> monthList,
                                  @Param("levelFlag")Integer levelFlag);

    TjOrgCountDto TjOrgCountSelf(@Param("orgId") Long orgId,
                                 @Param("typeIdsList") List<String> typeIdsList,
                                 @Param("sizeNameList") List<String> sizeNameList,
                                 @Param("year") Integer year,
                                 @Param("typeParentId")String typeParentId,
                                 @Param("monthList") List<Integer> monthList);

    List<TjOrgCountDto> TjOrgCountTotalNum(@Param("orgId") Long orgId,
                                           @Param("typeIdsList") List<String> typeIdsList,
                                           @Param("sizeNameList") List<String> sizeNameList,
                                           @Param("year") Integer year,
                                           @Param("typeParentId")String typeParentId,
                                           @Param("monthList") List<Integer> monthList,
                                           @Param("levelNum")Integer levelNum,
                                           @Param("level")Integer level,
                                           @Param("column")String column,
                                           @Param("order")String order);
    List<TjOrgCountDto> TjOrgCountTotalDetail(@Param("orgId") Long orgId,
                                              @Param("typeIdsList") List<String> typeIdsList,
                                              @Param("sizeNameList") List<String> sizeNameList,
                                              @Param("year") Integer year,
                                              @Param("typeParentId")String typeParentId,
                                              @Param("monthList") List<Integer> monthList,
                                              @Param("levelNum")Integer levelNum,
                                              @Param("level")Integer level,
                                              @Param("column")String column,
                                              @Param("order")String order);
    List<TjOrgCountDto> TjOrgCountDetail(@Param("orgId") Long orgId,
                                         @Param("typeIdsList") List<String> typeIdsList,
                                         @Param("sizeNameList") List<String> sizeNameList,
                                         @Param("year") Integer year,
                                         @Param("typeParentId")String typeParentId,
                                         @Param("monthList") List<Integer> monthList,
                                         @Param("levelNum")Integer levelNum,
                                         @Param("level")Integer level,
                                         @Param("column")String column,
                                         @Param("order")String order);

    FinalTjOrgCountDto TjOrgCountSum(@Param("orgId") Long orgId,
                                     @Param("sizeNameList") List<String> sizeNameList,
                                     @Param("typeIdsList") List<String> typeIdsList,
                                     @Param("year")Integer year);


    List<TjOrgCountDto> TjOrgCountByType(@Param("req") TjOrgCountReq req);

    void setSizeName(@Param("sizeId") String id,@Param("sizeName") String name);

    void setTypeName(@Param("typeId") String id,@Param("typeName") String name);


    List<Top5Dto> GetTop5(@Param("req") TjOrgCountReq req,@Param("length")Integer length);

    List<GroupByCountDto> GetGroupByCount(@Param("req") TjOrgCountReq req,@Param("length")Integer length);

    List<TjOutAndInDto> GetCount(@Param("req") TjOrgCountReq req,@Param("length")Integer length);

    List<String> getTypeParentName();

    List<AreaDto> GetAreaType(@Param("req")TjOrgCountReq req);
}




