package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum WarehouseExceptionEnum implements IExceptionEnum {
    /**
     * 仓库信息不存在
     */
    WAREHOUSE_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "仓库信息不存在"),
    WAREHOUSE_IS_LOCKED(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "仓库锁库中，记账失败"),
    WAREHOUSE_NAME_IS_EXIET(CommonConstant.DEFAULT_USER_ERROR_CODE + JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 12, "仓库名称已存在，请勿提交重复名称"),

    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    WarehouseExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
