package com.junmp.jyzb.api.bean.req;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class InventorySummaryReq {
    /**
     * 装备汇总id
     */
    private Long id;

    private String valuekey;
    /**
     * 组织机构id
     */
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;


    /**
     * 组织机构编码
     */
    private String orgCode;
    /**
     * 装备类型id
     */
    private String typeId;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 装备号型id
     */
    private String sizeId;

    /**
     * 号型名称
     */
    private String sizeName;

    /**
     * 位置类型，0代表仓库，1代表单警柜
     */
    private String locationType;

    /**
     * 位置信息id
     */
    private String locationId;

    /**
     * 位置名称
     */
    private String locationName;


    /**
     * 库存数量
     */
    private Integer number;

    /**
     * 物资单价
     */
    private BigDecimal unitPrice;

    /**
     * 总价
     */
    private BigDecimal price;

    /**
     * 在库数
     */
    private Integer stockNumber;

    private BigDecimal stockNumberPrice;
    /**
     * 出库数量
     */
    private Integer outboundNumber;
    private BigDecimal outboundNumberPrice;
    /**
     * 销毁数量
     */
    private Integer destructionNumber;
    private BigDecimal destructionNumberPrice;

    /**
     * 销毁金额
     */
    private BigDecimal destructionPrice;
    /**
     * 过质保数量
     */
    private Integer expireNumber;


    private BigDecimal expireNumberPrice;
    /**
     * 报废数量
     */

    private Integer brokenNumber;

    private BigDecimal brokenNumberPrice;
    /**
     * 临近报废数量
     */
    private Integer fixNumber;

    private Integer useCount;

    private Integer fixCount;

    /**
     * 使用中数量（领用和借用）
     */
    private Integer useNumber;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;


    /**
     * 物资阈值
     */
    private Integer threshold;

    /**
     * 审核中的报废数量（仅移入报废区的业务单使用）
     */
    private Integer agentBrokenNum;
}
