package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.junmp.v2.db.api.entity.BaseEntity;
import org.springframework.data.elasticsearch.annotations.Document;


@TableName("sys_log")
@Document(indexName = "sys_log", shards = 1, replicas = 1)
public class EsLog extends BaseEntity {
    @TableId(
            value = "log_id",
            type = IdType.ASSIGN_ID
    )
    private Long logId;
    @TableField("log_name")
    private String logName;
    @TableField("log_content")
    private String logContent;
    @TableField("app_name")
    private String appName;
    @TableField("log_type")
    private Integer logType;
    @TableField("request_url")
    private String requestUrl;
    @TableField("request_params")
    private String requestParams;
    @TableField("request_result")
    private String requestResult;
    @TableField("server_ip")
    private String serverIp;
    @TableField("client_ip")
    private String clientIp;
    @TableField("user_id")
    private Long userId;
    @TableField("http_method")
    private String httpMethod;
    @TableField("client_browser")
    private String clientBrowser;
    @TableField("client_os")
    private String clientOs;

    public EsLog() {
    }

    public Long getLogId() {
        return this.logId;
    }

    public String getLogName() {
        return this.logName;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public String getAppName() {
        return this.appName;
    }

    public Integer getLogType() {
        return this.logType;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getRequestParams() {
        return this.requestParams;
    }

    public String getRequestResult() {
        return this.requestResult;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getClientBrowser() {
        return this.clientBrowser;
    }

    public String getClientOs() {
        return this.clientOs;
    }

    public void setLogId(final Long logId) {
        this.logId = logId;
    }

    public void setLogName(final String logName) {
        this.logName = logName;
    }

    public void setLogContent(final String logContent) {
        this.logContent = logContent;
    }

    public void setAppName(final String appName) {
        this.appName = appName;
    }

    public void setLogType(final Integer logType) {
        this.logType = logType;
    }

    public void setRequestUrl(final String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setRequestParams(final String requestParams) {
        this.requestParams = requestParams;
    }

    public void setRequestResult(final String requestResult) {
        this.requestResult = requestResult;
    }

    public void setServerIp(final String serverIp) {
        this.serverIp = serverIp;
    }

    public void setClientIp(final String clientIp) {
        this.clientIp = clientIp;
    }

    public void setUserId(final Long userId) {
        this.userId = userId;
    }

    public void setHttpMethod(final String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setClientBrowser(final String clientBrowser) {
        this.clientBrowser = clientBrowser;
    }

    public void setClientOs(final String clientOs) {
        this.clientOs = clientOs;
    }

    public String toString() {
        return "SysLog(logId=" + this.getLogId() + ", logName=" + this.getLogName() + ", logContent=" + this.getLogContent() + ", appName=" + this.getAppName() + ", logType=" + this.getLogType() + ", requestUrl=" + this.getRequestUrl() + ", requestParams=" + this.getRequestParams() + ", requestResult=" + this.getRequestResult() + ", serverIp=" + this.getServerIp() + ", clientIp=" + this.getClientIp() + ", userId=" + this.getUserId() + ", httpMethod=" + this.getHttpMethod() + ", clientBrowser=" + this.getClientBrowser() + ", clientOs=" + this.getClientOs() + ")";
    }
}