package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.service.MQProductService;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Service
public class MQProductServicelmpl implements MQProductService {
    @Autowired
    RabbitTemplate rabbitTemplate;
    //通过converAndSend方法发送消息


    @Override
    public Boolean sendMessage() {
        //生成当前时间
        String createTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        try {
            //将记录当前时间的信息发送到消息队列
            rabbitTemplate.convertAndSend("Test1Exchange", "Test1Routing", "消息发送的时间为:" + createTime);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
