package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.NormalInOutDto;
import com.junmp.jyzb.api.bean.dto.WarehouseDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.SelectTotalNumReq;
import com.junmp.jyzb.api.bean.req.CabinetInOutRecordsReq;
import com.junmp.jyzb.api.bean.req.RabbitMqOrderReq;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.PriceSumSummaryMapper;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.v2.dict.entity.SysDictItem;
import com.junmp.v2.dict.service.SysDictItemService;
import liquibase.pro.packaged.L;
import org.springframework.stereotype.Service;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class InventorySummaryServiceImpl  extends ServiceImpl<InventorySummaryMapper, InventorySummary> implements InventorySummaryService {

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private OrderMainService orderMainService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    @Resource
    private EquipmentSizeService equipmentSizeService;

    @Resource
    private OrderDetailService orderDetailService;

    @Resource
    private WarehouseService warehouseService;

    @Resource
    private LogSummaryService logSummaryService;

    @Resource
    private LogDetailService logDetailService;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private SysDictItemService sysDictItemService;
    @Resource
    private PriceSumSummaryMapper PriceSumSummaryMapper;

    @Override
    public void MonthStartSum() {
        PriceSumSummaryMapper.MonthStart();
    }
    @Override
    public void MonthEndSum() {
        PriceSumSummaryMapper.MonthEnd();
        PriceSumSummaryMapper.MonthDifference();
    }
    //根据条件查询库存汇总信息
    @Override
    public PageResult<InventorySummary> getEquipmentInfo(InventorySumReq req) {
        //当没有参数传递的时候默认查询全部，但是如果传递了条件，根据条件查询并且如果是根据id进行查询，则需要判断该id是否存在
        //判断组织机构是否存在
        if (ObjectUtil.isNotNull(req.getOrgId())){
            pubOrgService.PubOrgExist(req.getOrgId());
        }
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<InventorySummary> wp = createWrapper(req);//取出仓库中总数并计算
        List<InventorySummary> list = list(wp);
        long size = list(wp).size();

            //对该装备typeId进行排序
        Collections.sort(list, new Comparator<InventorySummary>() {
            @Override
            public int compare(InventorySummary o1, InventorySummary o2) {
                return o1.getTypeId().compareTo(o2.getTypeId());
            }
        });

        Page<InventorySummary> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(list);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }

    /**
     * 用于出库单中的装备选择
     * @return
     */
    @Override
    public List<InventorySumDto> GetInventorySumInfo(InventorySumReq req) {

        return inventorySummaryMapper.GetInventorySumInfo(req);
    }

    @Override
    public InventorySummary getOne(InventorySumReq req) {
        LambdaQueryWrapper<InventorySummary> eq = new LambdaQueryWrapper<InventorySummary>()
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), InventorySummary::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(req.getLocationId()), InventorySummary::getLocationId, req.getLocationId())
                .eq(ObjectUtil.isNotEmpty(req.getTypeId()), InventorySummary::getTypeId, req.getTypeId())
                .eq(ObjectUtil.isNotEmpty(req.getSizeId()), InventorySummary::getSizeId, req.getSizeId())
                .eq(ObjectUtil.isNotEmpty(req.getUnitPrice()), InventorySummary::getUnitPrice, req.getUnitPrice());
        InventorySummary one = getOne(eq);
        return one;
    }


    //对summary表中数据进行重新计算装备信息汇总
    public Boolean updateSummaryInsByOrder(Long orgId){
        //查询字典表中的临近报废天数
        SysDictItem sysDictItem = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, "brokenNumber"));
        //如果配置找不到，那就默认设置为15天为临近报废（如果装备的质保期小于15天了，就是为临近报废）
        Integer brokenNumberDays;
        if (ObjectUtil.isNotNull(sysDictItem)){
            brokenNumberDays=15;
        }else {
            brokenNumberDays=Integer.parseInt(sysDictItem.getItemValue());
        }
        //查询出组织机构下的所有仓库信息，并且将表中的仓库信息数据进行删除
        List<WarehouseDto> allWarehouse = warehouseService.getAllWarehouse(orgId);
        boolean a = inventorySummaryMapper.deleteByWarehouse(allWarehouse);
        //根据仓库id重新计算汇总信息
        boolean sumByWarehouse = inventorySummaryMapper.getSumByWarehouse(allWarehouse, brokenNumberDays);
        return (a && sumByWarehouse);
    }

    //单警柜返回数据
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean cabinetInOutRecords(CabinetInOutRecordsReq req) {
        //批量修改装备信息
        List<InventoryReq> inventoryList = req.getInventoryList();
        boolean a=true;
        List<Inventory> inventoryLogsList=new ArrayList<>();
        for (InventoryReq inventoryReq:inventoryList) {
            Inventory inventory = new Inventory();
            BeanPlusUtil.copyProperties(inventoryReq,inventory);
            boolean result = inventoryService.saveOrUpdate(inventory);
            inventoryLogsList.add(inventory);
            if (!result){
                a=false;
                break;
            }
        }
        //修改summary表中数据
//        boolean b = updateSummaryInsByCabinet(req.getLocationId());
        //添加日志记录、
        Boolean c = insertCabinetLog(req,inventoryLogsList);
        return (a  && c);
    }


    public boolean updateSummaryInsByCabinet(String locationId){
        //查询字典表中的临近报废天数
        SysDictItem sysDictItem = sysDictItemService.getOne(new LambdaQueryWrapper<SysDictItem>()
                .eq(SysDictItem::getItemText, "brokenNumber"));
        //如果配置找不到，那就默认设置为15天为临近报废（如果装备的质保期小于15天了，就是为临近报废）
        Integer brokenNumberDays;
        if (ObjectUtil.isNotNull(sysDictItem)){
            brokenNumberDays=15;
        }else {
            brokenNumberDays=Integer.parseInt(sysDictItem.getItemValue());
        }
        //根据箱门id查询出单警柜信息
        CabinetBox cabinetBox = cabinetBoxService.getById(locationId);
        //删除inventorysummary表中该单警柜数据
        boolean a = inventorySummaryMapper.deleteByCabinet(cabinetBox.getCabinetId());
        //重新计算该单警柜下面的装备信息
        boolean b = inventorySummaryMapper.getSumByCabinet(cabinetBox.getCabinetId(),brokenNumberDays);
        return (a && b);
    }

    //添加单警柜出入库记录日志
    public Boolean insertCabinetLog(CabinetInOutRecordsReq req,List<Inventory> inventoryLogsList){

        LogSummary logSummary = new LogSummary();
        BeanPlusUtil.copyProperties(req,logSummary);
        logSummary.setLocationType(1);
        boolean a = logSummaryService.save(logSummary);
        List<LogDetail> logDetailList=new ArrayList<>();
        for (Inventory inventory:inventoryLogsList) {
            LogDetail logDetail = new LogDetail();
            BeanPlusUtil.copyProperties(inventory,logDetail);
            logDetail.setInventoryId(inventory.getId());
            logDetail.setCabinetboxId(req.getLocationId());
            logDetail.setOutInState(inventory.getLocationState());
            logDetail.setSummaryId(logSummary.getId());
            logDetailList.add(logDetail);
        }
        boolean b = logDetailService.saveBatch(logDetailList);
        return (a && b);
    }

    //根据组织机构id/单警柜id/仓库id查询出库存汇总数量以及金额
    @Override
    public List<InventorySummary> getTotalNumberAndPrice(InventorySumReq req) {
        List<InventorySummary> list=new ArrayList<>();
        InventorySummary totalNumberAndPrice = inventorySummaryMapper.getTotalNumberAndPrice(req);
        if (ObjectUtil.isNotNull(totalNumberAndPrice)){
            list.add(totalNumberAndPrice);
        }
        return list;
    }


    //计算装备总数（装备数量数据统计）
    @Override
    public List<InventorySummary> EquipmentStatistics(InventorySumReq req) {
        List<InventorySummary> inventorySummaryList=new ArrayList<>();
        InventorySummary inventorySummary = inventorySummaryMapper.EquipmentStatistics(req);
        if (ObjectUtil.isNotNull(inventorySummary)){
            inventorySummaryList.add(inventorySummary);
        }
        return inventorySummaryList;
    }


    //出入库时无单据查询库存汇总并统计更新或者记账时根据单据查询库存汇总并统计更新
    @Override
    public List<InventorySummary> selectSumByItems(List<Object[]> searchCriteria) {
        return inventorySummaryMapper.selectSumByItems(searchCriteria);
    }

    @Override
    public boolean insertToSummary() {
        String summaryTableName="base_inventory_summary_type2";
        String sourceTableName="base_inventory_copy1";
        //临近报废设置配置值
        //应该要去数据库进行查询，但是现在目前写死15天
        Integer warrantyThreshold=15;
        inventorySummaryMapper.insertToSummary(summaryTableName,sourceTableName,warrantyThreshold);
        return true;
    }

    @Override
    public List<InventorySumDto> selectTotalNum(SelectTotalNumReq req) {
        List<Object[]> searchCriteria=new ArrayList<>();
        if (req.getList().isEmpty()){
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR) ;
        }
        for (InventorySumReq inventorySumReq:req.getList()) {
            Object[] criteria=new Object[]{inventorySumReq.getTypeId(),inventorySumReq.getSizeId()};
            searchCriteria.add(criteria);
        }
        List<InventorySumDto> inventorySumDtoList=inventorySummaryMapper.selectTotalNum(req.getOrgId(),searchCriteria);
        return inventorySumDtoList;
    }


    private LambdaQueryWrapper<InventorySummary> createWrapper(InventorySumReq req) {
        LambdaQueryWrapper<InventorySummary> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        /**
         * 判断是否有高级搜索，如果有则进行添加查询条件
         */
        if (ObjectUtil.isNotNull(req.getNumber())){
            //将值进行切割，> = <并将其判断为哪个符号，如果为>则使用ge，=为eq，<为le
            String symbol = req.getNumber().substring(0, 1);
            String value = req.getNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getStockNumber())){
            String symbol = req.getStockNumber().substring(0, 1);
            String value = req.getStockNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getStockNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getStockNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getStockNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getOutboundNumber())){
            String symbol = req.getOutboundNumber().substring(0, 1);
            String value = req.getOutboundNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getOutboundNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getOutboundNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getOutboundNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getExpireNumber())){
            String symbol = req.getExpireNumber().substring(0, 1);
            String value = req.getExpireNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getExpireNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getExpireNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getExpireNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getBrokenNumber())){
            String symbol = req.getBrokenNumber().substring(0, 1);
            String value = req.getBrokenNumber().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getBrokenNumber,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getBrokenNumber,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getBrokenNumber,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getUnitPrice())){
            String symbol = req.getUnitPrice().substring(0, 1);
            String value = req.getUnitPrice().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getUnitPrice,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getUnitPrice,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getUnitPrice,value);
            }
        }
        if (ObjectUtil.isNotNull(req.getPrice())){
            String symbol = req.getPrice().substring(0, 1);
            String value = req.getPrice().substring(1);
            if (symbol.equals(">")){
                wrapper.gt(InventorySummary::getPrice,value);
            } else if (symbol.equals("=")) {
                wrapper.eq(InventorySummary::getPrice,value);
            }else if (symbol.equals("<")){
                wrapper.lt(InventorySummary::getPrice,value);
            }
        }
        //根据组织机构号查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), InventorySummary::getOrgId, req.getOrgId());
        //根据组织机构名模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getOrgName()), InventorySummary::getOrgName, req.getOrgName());
        //位置id（单警柜/仓库）
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLocationId()), InventorySummary::getLocationId, req.getLocationId());
        //位置类型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getLocationType()),InventorySummary::getLocationType,req.getLocationType());
        //位置信息
        wrapper.like(ObjectUtil.isNotEmpty(req.getLocationName()), InventorySummary::getLocationName, req.getLocationName());
        //装备类别名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getTypeName()), InventorySummary::getTypeName, req.getTypeName());
        //根据类别
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), InventorySummary::getTypeId, req.getTypeId());
        //型号名称
        wrapper.like(ObjectUtil.isNotEmpty(req.getSizeName()), InventorySummary::getSizeName, req.getSizeName());
        //号型
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), InventorySummary::getSizeId, req.getSizeId());
        wrapper.last("order by " + req.getColumn() + " " + req.getOrder());

        return wrapper;
    }
}
