package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data

public class UpdateEquipmentTypeReq {
    @NotBlank(message = "装备主键不能为空", groups = {ValidationApi.edit.class, ValidationApi.delete.class, ValidationApi.detail.class})
    private String id;
    @NotBlank(message = "状态不能为空", groups = { ValidationApi.updateStatus.class})
    private String state;

    private String unitType;
    @NotBlank(message = "编码不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String code;
    @NotBlank(message = "名称不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String name;

    private String note;
    @NotBlank(message = "上级不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String parentId;
    @NotBlank(message = "上级集合不能为空", groups = {ValidationApi.edit.class,  ValidationApi.add.class})
    private String parentIds;

    private int warrantyPeriod;

    private int maintenancePeriod;

    private int type;
    private String photo;

    private List<String> supplierList;
}
