package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.ManufacturerReq;
import com.junmp.jyzb.api.exception.enums.ManufacturerExceptionEnum;
import com.junmp.jyzb.entity.Manufacturer;
import com.junmp.jyzb.service.ManufacturerService;
import com.junmp.jyzb.mapper.ManufacturerMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_manufacturer】的数据库操作Service实现
* @createDate 2023-09-15 10:15:29
*/
@Service
public class ManufacturerServiceImpl extends ServiceImpl<ManufacturerMapper, Manufacturer>
    implements ManufacturerService{

    @Override
    public String addManufacturer(ManufacturerReq req) {
        //判断是否已经存在生产厂商短码，如果存在则不再允许添加成功
        Manufacturer one = getOne(new LambdaQueryWrapper<Manufacturer>().eq(Manufacturer::getCode, req.getName()));
        if (ObjectUtil.isNotNull(one)){
            throw new ServiceException(ManufacturerExceptionEnum.MANUTACTURER_IS_EXIST);
        }
        Manufacturer manufacturer = new Manufacturer();
        BeanPlusUtil.copyProperties(req,manufacturer);
        manufacturer.setCreateTime(DateTimeUtil.getCurrentDateTime());
        save(manufacturer);
        return manufacturer.getId();
    }

    @Override
    public boolean updateManufacturer(ManufacturerReq req) {
        Manufacturer manufacturer = new Manufacturer();
        BeanPlusUtil.copyProperties(req,manufacturer);
        manufacturer.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return updateById(manufacturer);
    }

    @Override
    public List<Manufacturer> showManufacturerList(ManufacturerReq req) {
        LambdaQueryWrapper<Manufacturer> wrapper = createWrapper(req);
        return  list(wrapper);
    }

    @Override
    public PageResult<Manufacturer> showManufacturerPage(ManufacturerReq req) {
        LambdaQueryWrapper<Manufacturer> wrapper = createWrapper(req);
        Page<Manufacturer> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), wrapper);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public boolean delManufacturer(ManufacturerReq req) {
        //抛出异常，生产厂商未选中
        if (req.getDeleteList().size()==0){
            throw new ServiceException(ManufacturerExceptionEnum.MANUFACTURER_NOT_CHOOSE);
        }
        //查询出全部的生产厂商
        Set<String> collect = list().stream().map(Manufacturer::getId).collect(Collectors.toSet());
        Set<String> delList=new HashSet<>(req.getDeleteList());
        if (collect.containsAll(delList)){
            return removeBatchByIds(req.getDeleteList());
        }else {
            throw new ServiceException(ManufacturerExceptionEnum.MANUFACTURER_ISNOT_EXIST);
        }
    }

    private LambdaQueryWrapper<Manufacturer> createWrapper(ManufacturerReq req){
        LambdaQueryWrapper<Manufacturer> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)){
            return wrapper;
        }
        wrapper.eq(ObjectUtil.isNotNull(req.getId()),Manufacturer::getId,req.getId());
        wrapper.eq(ObjectUtil.isNotNull(req.getState()),Manufacturer::getState,req.getState());
        wrapper.like(ObjectUtil.isNotNull(req.getName()),Manufacturer::getName,req.getName());
        wrapper.like(ObjectUtil.isNotNull(req.getShortName()),Manufacturer::getShortName,req.getShortName());
        wrapper.like(ObjectUtil.isNotNull(req.getContacts()),Manufacturer::getContacts,req.getContacts());
        wrapper.orderByDesc(Manufacturer::getCreateTime);
        return wrapper;
    }
}




