package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

@ApiModel(value = "com-junmp-jyzb-domain-EquipmentType")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_equipment_type")
@Document(indexName = "type_pinyin")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquipmentType implements Serializable {
    /**
     * 装备类型ID
     */
    @ApiModelProperty(value = "装备类型ID")
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    @Id
    private String id;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称")
    private String name;
    /**
     * 类型名称
     */
    @ApiModelProperty(value = "别名")
    private String nickName;
    /**
     * 单位
     */
    @ApiModelProperty(value = "单位")
    private String unit;

    /**
     * 单位类型
     */
    @ApiModelProperty(value = "单位类型")
    @TableField("unit_type")
    private String unitType;

    /**
     * 装备Code码
     */
    @ApiModelProperty(value = "装备Code码")
    private String code;

    /**
     * 上级id
     */
    @ApiModelProperty(value = "上级id")
    @TableField("parent_id")
    private String parentId;

    /**
     * 上级ids
     */
    @ApiModelProperty(value = "上级id")
    @TableField("parent_ids")
    private String parentIds;


    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "update_time")
    private Date updateTime;
    /**
     * 当前状态:0关闭/1启用
     */
    @ApiModelProperty(value = "当前状态:0关闭/1启用")
    private Integer state;

    /**
     * 当前状态:0关闭/1启用
     */
    @TableField("warranty_period")
    private Integer warrantyPeriod;

    /**
     * 当前状态:0关闭/1启用
     */
    @TableField("maintenance_period")
    private Integer maintenancePeriod;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 原id
     */
    @ApiModelProperty(value = "原id")
    private String guid;
    /**
     *  类别下的最大id
     */
    @TableField(value = "max_code")
    private Integer maxCode;

    /**
     * 类型，0类别，1装备
     */
    @ApiModelProperty(value = "类型，0类别，1装备")
    private Integer type;

    /**
     * 物资阈值
     */
    @ApiModelProperty(value = "物资阈值")
    private Integer threshold;




    private static final long serialVersionUID = 1L;
}