package com.junmp.jyzb.api.bean.query;


import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class WarehouseReq extends BaseRequest {
    @NotBlank(message = "仓库主键不能为空", groups = {updateStatus.class, delete.class, detail.class})
    private String id;

    private String name;

    private String location;

    private String phone;

    private String video;

    private Date createTime;

    private Date updateTime;

    private String updateUser;

    @NotNull(message = "组织机构id不能为空", groups = {edit.class})
    private Long orgId;

    private Boolean isLocked;

    private Integer sum;

    private Integer outSum;

    private Integer inSum;

    private BigDecimal priceTotal;

    @NotNull(message = "仓库状态不能为空", groups = {updateStatus.class})
    private Integer state;

    private Long orderId;

    private String IncludeLowerLevel;
}