package com.junmp.junmpProcess.service.Bussiness.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.junmp.junmpProcess.cmd.DeleteFlowableProcessInstanceCmd;
import com.junmp.junmpProcess.dto.*;
import com.junmp.junmpProcess.dto.json.*;
import com.junmp.junmpProcess.entity.ProcessTemplates;
import com.junmp.junmpProcess.exception.WorkFlowException;
import com.junmp.junmpProcess.mapper.ProcessTemplatesMapper;
import com.junmp.junmpProcess.mapper.TemplateGroupMapper;
import com.junmp.junmpProcess.service.Bussiness.WorkProcessService;
import com.junmp.junmpProcess.service.Repository.ProcessTemplateService;
import com.junmp.junmpProcess.utils.IdWorker;
import com.junmp.junmpProcess.utils.SpringContextHolder;
import com.junmp.junmpProcess.vo.*;
import com.junmp.jyzb.api.bean.req.ProcessReq.FormReq;
import com.junmp.jyzb.api.bean.req.ProcessReq.SuspendOrActivateDefinitionReq;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.auth.api.LoginUserApi;
import com.junmp.v2.auth.api.bean.login.LoginUser;
import com.junmp.v2.auth.api.context.LoginContext;
import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.model.*;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.*;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.engine.task.Attachment;
import org.flowable.engine.task.Comment;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import com.junmp.junmpProcess.common.Result;
import com.junmp.junmpProcess.common.WorkFlowConstants;
import com.junmp.junmpProcess.dto.json.flowJson.FlowChildNode;
import com.junmp.junmpProcess.dto.json.flowJson.Inout;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

import static com.junmp.junmpProcess.common.CommonConstants.*;
import static com.junmp.junmpProcess.common.WorkFlowConstants.PROCESS_PREFIX;
import static com.junmp.junmpProcess.utils.BpmnConvert.toBpmn;
import static com.junmp.junmpProcess.utils.BpmnModelUtils.*;


@Service
public class WorkProcessServiceImpl extends ServiceImpl<ProcessTemplatesMapper, ProcessTemplates> implements WorkProcessService {


    @Autowired
    private ProcessTemplateService processTemplateService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    protected ManagementService managementService;

    @Resource
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;
    @Resource
    private TaskService taskService;
    @Resource
    private IdWorker idWorker;


    /**
     * 创建子任务
     *
     * @param ptask    创建子任务
     * @param assignee 子任务的执行人
     * @return
     */
    protected  TaskEntity createSubTask(TaskEntity ptask, String ptaskId, String assignee) {
        TaskEntity task = null;
        if (ptask != null) {
            //1.生成子任务
            task = (TaskEntity) taskService.newTask(UUID.randomUUID().toString());
            task.setCategory(ptask.getCategory());
            task.setDescription(ptask.getDescription());
            task.setTenantId(ptask.getTenantId());
            task.setAssignee(assignee);
            task.setName(ptask.getName());
            task.setParentTaskId(ptaskId);
            task.setProcessDefinitionId(ptask.getProcessDefinitionId());
            task.setProcessInstanceId(ptask.getProcessInstanceId());
            task.setTaskDefinitionKey(ptask.getTaskDefinitionKey());
            task.setTaskDefinitionId(ptask.getTaskDefinitionId());
            task.setPriority(ptask.getPriority());
            task.setCreateTime(new Date());
            taskService.saveTask(task);
        }
        return task;
    }
    public  Boolean turn(TurnVo turns)
    {


        TaskEntityImpl currTask = (TaskEntityImpl) taskService.createTaskQuery().taskId(turns.getTaskId()).singleResult();
        if (currTask != null) {
            //1.生成历史记录
            TaskEntity task =this.createSubTask(currTask,currTask.getId(),turns.getUserId());
            //2.添加审批意见
//          this.addComment(task.getId(), turnTaskVo.getUserCode(), turnTaskVo.getProcessInstanceId(), CommentTypeEnum.ZB.toString(), turnTaskVo.getMessage());
            taskService.saveTask(task);
            taskService.complete(task.getId());
            //3.转办
            taskService.setAssignee(turns.getTaskId(), turns.getUserId());
            String[] assigneeList=turns.getAssigneeList();
            for (String owner :assigneeList
                 ) {
                taskService.setOwner(turns.getTaskId(), owner);
            }

            return  true;
        } else {
            return  false;

        }
    }
    public PageResult<TemplateGroupVo> getFormList(BaseRequest br)
    {
        LambdaQueryWrapper<ProcessTemplates> wrapper = new LambdaQueryWrapper<ProcessTemplates>();
        wrapper.orderByDesc(ProcessTemplates::getUpdated);
        TemplateGroupMapper templateGroupMapper = SpringContextHolder.getBean(TemplateGroupMapper.class);
        Page<ProcessTemplates> allformAndGroups =this.page(PageFactory.getDefaultPage(),wrapper);
//        templateGroupMapper.getAllFormAndGroups();
        Map<Integer, List<ProcessTemplates>> coverMap = new LinkedHashMap<>();
        allformAndGroups.getRecords().forEach(fg -> {
            List<ProcessTemplates> bos = coverMap.get(fg.getGroupId());
            if (CollectionUtil.isEmpty(bos)) {
                List<ProcessTemplates> list = new ArrayList<>();
                list.add(fg);
                coverMap.put(fg.getGroupId(), list);
            } else {
                bos.add(fg);
            }
        });
        PageResult<TemplateGroupVo> pageResult=new  PageResult<TemplateGroupVo>();

        coverMap.forEach((key, val) -> {
            List<TemplateGroupVo> templates = new ArrayList<>();
            val.forEach(v -> {
                if (ObjectUtil.isNotNull(v.getTemplateId())) {
                    String defId="";
                    ProcessDefinition ProDef=repositoryService.createProcessDefinitionQuery()
                            .processDefinitionKey("Process_"+v.getTemplateId())
                            .latestVersion()
                            .singleResult();
                    if(ProDef!=null)
                    {
                        defId=ProDef.getId();
                    }
                    templates.add(TemplateGroupVo.builder()
                            .formId(v.getTemplateId())
                            .remark(v.getRemark())
                            .formName(v.getFormName())
                            .isStop(v.getIsStop())
                            .updated(DateFormatUtils.format(v.getUpdated(),"yyyy年MM月dd日 HH时:mm分:ss秒"))
                            .templateId(v.getTemplateId())
                            .processDefinitionId(defId)
                            .build());
                }
            });
            pageResult.setRecords( templates);
        });
        pageResult.setPageSize(allformAndGroups.getSize());
        pageResult.setTotalRows( allformAndGroups.getTotal());
        pageResult.setPageNo(allformAndGroups.getPages());
        pageResult.setTotalPage(PageUtil.totalPage(Convert.toInt(pageResult.getTotalRows()), Convert.toInt(pageResult.getPageSize())));
        return  pageResult;
    }

    /**
    * @Author: Zhaojw
    * @Description: 创建新表单
    * @DateTime: 2023/7/24 11:50
    * @Params:
    * @Return
    */
    public Boolean createNewForm(FormReq req)  {

        ProcessTemplates processTemplates = ProcessTemplates.builder().build();
        String templateId = idWorker.nextId()+"";
        processTemplates.setTemplateId(templateId);
        processTemplates.setFormName(req.getFormName());
        processTemplates.setRemark(req.getRemark());
        processTemplates.setIsStop(true);
        Date date= new Date();

        processTemplates.setUpdated(date);
        processTemplateService.save(processTemplates);
        return true;
    }


    @Override
    public Boolean suspendOrActivateProcessDefinitionById(SuspendOrActivateDefinitionReq req) {
        ProcessTemplates processTemplates = processTemplateService.getById(req.getTemplateId());
        if (req.getIsStop() == true){
            repositoryService.suspendProcessDefinitionById(req.getProcessDefinitionId(), true, null);
            processTemplates.setIsStop(true);

        }else {
            processTemplates.setIsStop(false);
            repositoryService.activateProcessDefinitionById(req.getProcessDefinitionId(), true, null);

        }
        processTemplates.setUpdated(new Date());
       return   processTemplateService.updateById(processTemplates);//更新表单明细表信息

    }

    public Boolean createBpmn(ProcessVO processVO) throws JsonProcessingException {
        //流程定义
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode processJsonNode = objectMapper.readTree(processVO.getProcessJson());
        JsonNode formJsonNode = objectMapper.readTree(processVO.getFormJson());
        String formName=processVO.getFormName().toString();
        ProcessTemplates processTemplates = ProcessTemplates.builder().build();
        String templateId = idWorker.nextId()+"";
        processTemplates.setTemplateId(templateId);

        processTemplates.setFormJson(formJsonNode.toString());
        processTemplates.setProcessJson(processJsonNode.toString());
        processTemplates.setFormName(processVO.getFormName());
        processTemplates.setIsStop(false);
        Date date= new Date();

        processTemplates.setUpdated(date);
        processTemplateService.save(processTemplates);
        //将json转换为bpmn

        BpmnModel bpmnModel = toBpmn(processJsonNode,formJsonNode,formName,templateId);
        Deployment deploy = repositoryService.createDeployment()
                .addBpmnModel(templateId+".bpmn20.xml", bpmnModel)
                .name(templateId)
                .category(templateId)
                .deploy();

        return true;

    }


    /**
    * @Author: Zhaojw
    * @Description: 删除流程实例
    * @DateTime: 2023/7/22 10:16
    * @Params:
    * @Return
    */
    public  Boolean deleteProcessInstance(ProcessDTO processInstance)
    {
        List<ProcessInstance> processInstances = runtimeService.createProcessInstanceQuery()
                .processDefinitionId(processInstance.getProcessDefinitionId())
                .list();
        // 使用增强型 for 循环遍历列表
        for (ProcessInstance processInstancesItem : processInstances) {
            // 在这里对每个 ProcessInstance 进行处理

            long count = runtimeService.createProcessInstanceQuery().processInstanceId(processInstancesItem.getId()).count();
            if (count > 0) {

                DeleteFlowableProcessInstanceCmd cmd = new DeleteFlowableProcessInstanceCmd(processInstancesItem.getId(), "删除流程实例", true);
                managementService.executeCommand(cmd);

                // 删除与已删除流程定义相关的部署数据
                repositoryService.deleteDeployment(processInstancesItem.getDeploymentId(), true);
            } else {
                HistoricProcessInstanceQuery query= historyService.createHistoricProcessInstanceQuery()
                        .processInstanceId(processInstancesItem.getId());
                // 查询历史流程实例数据
                HistoricProcessInstance historicProcessInstance = query.singleResult();
                if (historicProcessInstance != null) {
                    historyService.deleteHistoricProcessInstance(processInstancesItem.getId());
                }
            }
        }
        ProcessTemplates pro=processTemplateService.getById(processInstance.getTemplateId());
        if (pro!=null)
        {
            processTemplateService.removeById(processInstance.getTemplateId());
        }
        return  true;


    }


    /**
    * @Author: Zhaojw
    * @Description: 修改表单名称
    * @DateTime: 2023/7/21 14:30
    * @Params:
    * @Return
    */
    public Boolean updateFormName(UpdateProcessVO process)  {
        ProcessTemplates processTemplates = processTemplateService.getById(process.getTemplateId());
        processTemplates.setFormName(process.getFormName());
        processTemplates.setRemark(process.getRemark());
        processTemplates.setUpdated(new Date());

        return processTemplateService.updateById(processTemplates);//更新表单明细表信息


    }
    
    /**
     * 编辑表单详情
     *
     * @return 修改结果
     */

    @Transactional
    public Boolean updateForm(UpdateProcessVO process) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode processJsonNode = objectMapper.readTree(process.getProcessJson());
        JsonNode formJsonNode = objectMapper.readTree(process.getFormJson());
        String formName="";
        ProcessTemplates processTemplates = processTemplateService.getById(process.getTemplateId());
        if (ObjectUtil.isNotEmpty(process.getFormName()))
        {
            formName= process.getFormName().toString();
            processTemplates.setFormName(process.getFormName());
        }
        processTemplates.setFormJson(formJsonNode.toString());
        processTemplates.setProcessJson(processJsonNode.toString());
        String fj=process.getFormJson().toString();
//        processTemplates.setFormJson(process.getFormJson().toString());
        processTemplates.setProcessJson(process.getProcessJson().toString());
        processTemplates.setUpdated(new Date());
        processTemplateService.updateById(processTemplates);//更新表单明细表信息
        BpmnModel bpmnModel = toBpmn(processJsonNode,formJsonNode,formName,process.getTemplateId());


        Deployment deploy = repositoryService.createDeployment()
                .addBpmnModel(process.getTemplateId()+".bpmn20.xml", bpmnModel)
                .name(process.getTemplateId())
                .category(process.getTemplateId())
                .deploy();
        return true;

    }

    @Override
    public ResponseResult getFormDetail(String templateId) {
        ProcessTemplates processTemplates = processTemplateService.getById(templateId);
        processTemplates.setIcon(processTemplates.getIcon());
        processTemplates.setTemplateId(processTemplates.getTemplateId());
        processTemplates.setFormName(processTemplates.getFormName());
        Object aa= repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionKey("Process_"+templateId).latestVersion().singleResult();
        if(processDefinition==null){
            throw  new WorkFlowException("该流程暂未接入Flowable,请重试");
        }
        processTemplates.setProcessDefinitionId(processDefinition.getId());

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,processTemplates);
    }

    /**
     * 绘制节点
     *
     * @param process       bpmn process 图纸
     * @param node          json的节点
     * @param preId         上一节点id
     * @param endId         结束节点
     * @param preExpression 上一节点表达式
     */
    public void drawNode(Process process, JsonNode node, String preId, String endId, String preExpression) {
        // 根据type绘制不同种类的节点
        Inout inout = drawNodeByType(process, node);
        // 绘制前一根线
        process.addFlowElement(createSequenceFlow(preId, inout.getIn(), preExpression));
        if (node.get("childNode").toString().equals("null")) {
            // 没有下一步, 绘制指向结束的线
            process.addFlowElement(createSequenceFlow(inout.getOut(), endId, null));
        } else {
            // 有下一步, 递归绘制下一个节点
            drawNode(process, node.get("childNode"), inout.getOut(), endId, null);
        }
    }

    /**
     * 绘制不同种类节点
     *
     * @param process
     * @param node
     * @return
     */
    private Inout drawNodeByType(Process process, JsonNode node) {
        if (node.get("type").toString().equals("0")) {//根节点或起始节点
            return drawRootNode(process, node);
        } else if (node.get("type").toString().equals("1")) {//审核节点
            return drawAuditNode(process, node);
        } else if (node.get("type").toString().equals("3")) {//分支节点
            return drawExclusiveNode(process, node);
        } else if (node.get("type").toString().equals("4")) {//分支节点
            return drawExclusiveNode(process, node);
        } else {
            throw new IllegalArgumentException();
        }
    }

    /**
     * 绘制分支节点
     *
     * @param process
     * @param node
     * @return
     */
    private Inout drawExclusiveNode(Process process, JsonNode node) {
        // 开始网关
        String startId = "Exclusive_" + UUID.randomUUID();
        ExclusiveGateway startGateway = new ExclusiveGateway();
        startGateway.setId(startId);
        process.addFlowElement(startGateway);
        // 结束网关
        String endId = "Exclusive_" + UUID.randomUUID();
        ExclusiveGateway endGateway = new ExclusiveGateway();
        endGateway.setId(endId);
        process.addFlowElement(endGateway);

        // int和out不一样
        return new Inout(startId, endId);
    }

    /**
     * 创建连线
     *
     * @param from
     * @param to
     * @return
     */
    public SequenceFlow createSequenceFlow(String from, String to, String conditionExpression) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(from + "-" + to);
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        if (conditionExpression != null) {
            flow.setConditionExpression(conditionExpression);
        }
        return flow;
    }

    /**
     * 绘制根节点
     *
     * @param process
     * @param node
     * @return
     */
    private Inout drawRootNode(Process process, JsonNode node) {

        String id = "Node_" + UUID.randomUUID();
        // 如果当前任务还有后续任务，则遍历创建后续任务
        JsonNode nextNode = node.get("childNode");
        UserTask userTask = new UserTask();
        userTask.setName(node.get("name").toString());
        userTask.setId(id);
        process.addFlowElement(userTask);
        return new Inout(id, id);

    }

    private static String createSimpleUserTask(JSONObject flowNode, Process process, List<SequenceFlow> sequenceFlows) {
        List<String> incoming = flowNode.getJSONArray("incoming").toJavaList(String.class);
        // 自动生成id
        String id = id("userTask");
        if (incoming != null && !incoming.isEmpty()) {
            UserTask userTask = new UserTask();
            userTask.setName(flowNode.getString("name"));
            userTask.setId(id);
            process.addFlowElement(userTask);
            process.addFlowElement(connect(incoming.get(0), id, sequenceFlows));
        }
        return id;
    }

    /**
     * 连线
     *
     * @param from
     * @param to
     * @param sequenceFlows
     * @return
     */
    protected static SequenceFlow connect(String from, String to, List<SequenceFlow> sequenceFlows) {
        SequenceFlow flow = new SequenceFlow();
        flow.setId(id("sequenceFlow"));
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        sequenceFlows.add(flow);
        return flow;
    }

    private static String id(String prefix) {
        return prefix + "_" + UUID.randomUUID().toString().replace("-", "").toLowerCase();
    }

    /**
     * 绘制审核节点
     *
     * @param process
     * @param node
     * @return
     */
    private Inout drawAuditNode(Process process, JsonNode node) {
        // 绘制节点
        String id = "Node_" + UUID.randomUUID();
        UserTask userTask = new UserTask();
        userTask.setId(id);
        userTask.setName(node.get("name").toString());
        // 设置多实例
//                userTask.setAssignee("${user}");
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
//                if (node.getAssignee().getMultiMode().equals("顺序审批")) {
//                        multiInstanceLoopCharacteristics.setSequential(true);
//                }
        multiInstanceLoopCharacteristics.setElementVariable("user");
        // 完成条件
        multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfInstances == nrOfCompletedInstances}");
        multiInstanceLoopCharacteristics.setInputDataItem("${users}");
        userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        // 保存json节点配置到扩展属性
        Map<String, Object> extensions = new HashMap<>();
        extensions.put("node", node);
        process.addFlowElement(userTask);
        ;
        return new Inout(id, id);
    }

    private BpmnModel assemBpmnModel(FlowChildNode childNode,
                                     Integer groupId) {
        BpmnModel bpmnModel = new BpmnModel();
        List<SequenceFlow> sequenceFlows = Lists.newArrayList();
        Map<String, ChildNode> childNodeMap = new HashMap<>();
        bpmnModel.setTargetNamespace(groupId + "");
        Process process = new Process();
        process.setId(WorkFlowConstants.PROCESS_PREFIX);

        bpmnModel.addProcess(process);

        StartEvent startEvent = createStartEvent();
        process.addFlowElement(startEvent);
        String lastNode = null;
        EndEvent endEvent = createEndEvent();
        process.addFlowElement(endEvent);
        List<FlowableListener> executionListeners = new ArrayList<>();
        FlowableListener flowableListener = new FlowableListener();
        flowableListener.setEvent(ExecutionListener.EVENTNAME_END);
        flowableListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
        flowableListener.setImplementation("${processListener}");
        executionListeners.add(flowableListener);
        process.setExecutionListeners(executionListeners);
        new BpmnAutoLayout(bpmnModel).execute();
        return bpmnModel;
    }




    /**
     * 通过模板id查看流程信息 会附带流程定义id
     *
     * @return
     */
    @Override
    public Result<ProcessTemplates> detail(String templateId) {
        ProcessTemplates processTemplates = processTemplateService.getById(templateId);
        processTemplates.setFormId(processTemplates.getTemplateId());
        processTemplates.setFormName(processTemplates.getFormName());
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_PREFIX + templateId).latestVersion().singleResult();
        if (processDefinition == null) {
            throw new WorkFlowException("该流程暂未接入Flowable,请重试");
        }

        return Result.OK(processTemplates);
    }

    /**
     * 通过流程定义id启动流程
     *
     * @return
     */
    @Override
    public ApiRes<Boolean> start(StartProcessInstanceDTO processInstanceDto) {
        try {
            LoginUserApi user= LoginContext.getContext();

            LoginUser StartUser= LoginContext.getContext().getLoginUser();
            JSONObject formData = processInstanceDto.getFormData();
//            JunmpUserInfo startUserInfo = processInstanceDto.getStartUserInfo();
            Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());

            Map<String,Object> processVariables= new HashMap<>();
            processVariables.put(FORM_VAR,formData);
            processVariables.put(START_USER_INFO,JSONObject.toJSONString(StartUser));
            processVariables.put(PROCESS_STATUS,BUSINESS_STATUS_1);


//            processVariables.put("initiator",JSONObject.toJSONString(startUserInfo));
            ArrayList<LoginUser> userInfos = CollUtil.newArrayList(StartUser);
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            processVariables.putAll(formValue);


            ProcessInstanceBuilder processInstanceBuilder = runtimeService.createProcessInstanceBuilder();
            ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionKey(processInstanceDto.getProcessDefinitionId())
                    .latestVersion().singleResult();
//            if (processDefinition == null )
//            {
//                return  ApiRes.failure("流程不存在或已挂起");
//
//           }
//            if (processDefinition != null && processDefinition.isSuspended())
//            {
//                return  ApiRes.failure("流程不存在或已挂起");
//            }
            ProcessInstance processInstance = processInstanceBuilder
                    .processDefinitionId(processInstanceDto.getProcessDefinitionId())
                    .variable("initiator",StartUser.getUserId())
                    .variables(processVariables)
                    .businessStatus(BUSINESS_STATUS_1)
                        .start();
                        //手动完成第一个任务
            Task task = taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
            Object ts=new Object();
            if(task!=null){
                taskService.complete(task.getId());

            }
            return  ApiRes.success(true);
        }
        catch (Exception e){
            Throwable cause = e.getCause();
            if(cause instanceof WorkFlowException){
                WorkFlowException workFlowException=(WorkFlowException)cause;
                return  ApiRes.failure(workFlowException.getMessage());


            }
            e.printStackTrace();
            return  ApiRes.failure("流程不存在或已挂起");
        }
    }

    /**
     * 查看我发起的流程
     *
     * @return
     */
    @Override
    public PageResult<HistoryProcessInstanceVO>  applyList(ApplyDTO applyDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();
        PageResult<HistoryProcessInstanceVO> pageResult=new  PageResult<HistoryProcessInstanceVO>();
        List<HistoricProcessInstance> historicProcessInstances =
                historyService.createHistoricProcessInstanceQuery()
                        .includeProcessVariables()
                        .startedBy(StartUser.getUserId().toString())
                        .orderByProcessInstanceStartTime().desc()
                        .listPage((applyDTO.getPageNo() - 1) * applyDTO.getPageSize(), applyDTO.getPageSize());
        long count = historyService.createHistoricProcessInstanceQuery()
                .startedBy(StartUser.getUserId().toString()).count();
        List<HistoryProcessInstanceVO> historyProcessInstanceVOS = new ArrayList<>();
        Page<HistoryProcessInstanceVO> page = new Page<>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            Map<String, Object> processVariables = historicProcessInstance.getProcessVariables();
            HistoryProcessInstanceVO historyProcessInstanceVO = new HistoryProcessInstanceVO();
            historyProcessInstanceVO.setProcessInstanceId(historicProcessInstance.getId());
            historyProcessInstanceVO.setProcessDefinitionName(historicProcessInstance.getProcessDefinitionName());
            historyProcessInstanceVO.setStartUser(JSONObject.parseObject(MapUtil.getStr(processVariables, START_USER_INFO), new TypeReference<UserInfo>() {
            }));
            historyProcessInstanceVO.setStartTime(historicProcessInstance.getStartTime());
            historyProcessInstanceVO.setEndTime(historicProcessInstance.getEndTime());
            Boolean flag = historicProcessInstance.getEndTime() == null ? false : true;
            historyProcessInstanceVO.setCurrentActivityName(getCurrentName(historicProcessInstance.getId(), flag, historicProcessInstance.getProcessDefinitionId()));
            historyProcessInstanceVO.setBusinessStatus(MapUtil.getStr(processVariables, PROCESS_STATUS));

            long totalTimes = historicProcessInstance.getEndTime() == null ?
                    (Calendar.getInstance().getTimeInMillis() - historicProcessInstance.getStartTime().getTime()) :
                    (historicProcessInstance.getEndTime().getTime() - historicProcessInstance.getStartTime().getTime());
            long dayCount = totalTimes / (1000 * 60 * 60 * 24);//计算天
            long restTimes = totalTimes % (1000 * 60 * 60 * 24);//剩下的时间用于计于小时
            long hourCount = restTimes / (1000 * 60 * 60);//小时
            restTimes = restTimes % (1000 * 60 * 60);
            long minuteCount = restTimes / (1000 * 60);

            String spendTimes = dayCount + "天" + hourCount + "小时" + minuteCount + "分";
            historyProcessInstanceVO.setDuration(spendTimes);
            historyProcessInstanceVOS.add(historyProcessInstanceVO);
        }
        pageResult.setRecords(historyProcessInstanceVOS);
        pageResult.setTotalRows(Long.valueOf(applyDTO.getPageNo()));
        pageResult.setTotalPage(PageUtil.totalPage((int) count, Convert.toInt(pageResult.getPageSize())));
        pageResult.setPageSize(Long.valueOf(applyDTO.getPageSize()));
        pageResult.setPageNo(Long.valueOf(applyDTO.getPageNo()));
        return  pageResult;
    }

    /**
     * 查看我的待办
     *
     * @return
     */
    @Override
    public PageResult<TaskVO> toDoList(TaskDTO taskDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();
        List<Task> tasks = taskService.createTaskQuery().taskAssignee(StartUser.getUserId().toString())
                .includeProcessVariables()
                .orderByTaskCreateTime().desc()
                .listPage((taskDTO.getPageNo() - 1) * taskDTO.getPageSize(), taskDTO.getPageSize());
        long count = taskService.createTaskQuery().taskAssignee(StartUser.getUserId().toString()).count();
        List<TaskVO> taskVOS= new ArrayList<>();
        Page<TaskVO> page =new Page<>();
        for (Task task : tasks) {
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String startUserId = processInstance.getStartUserId();
            BpmnModel bpmnModel = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            Map<String, Object> processVariables = task.getProcessVariables();
            TaskVO taskVO=new TaskVO();
            taskVO.setTaskId(task.getId());
            taskVO.setProcessInstanceId(task.getProcessInstanceId());
            taskVO.setProcessDefinitionName(bpmnModel.getMainProcess().getName());
            UserInfo user=new UserInfo();
            user.setId(startUserId);
            taskVO.setStartUser(user);
            taskVO.setStartTime(processInstance.getStartTime());
            taskVO.setCurrentActivityName(getCurrentName(processInstance.getId(),false,processInstance.getProcessDefinitionId()));

            taskVO.setBusinessStatus(MapUtil.getStr(processVariables,PROCESS_STATUS));
            taskVO.setTaskCreatedTime(task.getCreateTime());
            DelegationState delegationState = task.getDelegationState();
            if(delegationState!=null){
                taskVO.setDelegationState(delegationState);
            }
            taskVOS.add(taskVO);
        }

        page.setRecords(taskVOS);
        return PageResultFactory.createPageResult(page);


    }

    /**
     * 查看我的已办
     *
     * @return
     */
    @Override
    public Result<Page<TaskVO>> doneList(TaskDTO taskDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();
        List<HistoricTaskInstance> tasks = historyService.createHistoricTaskInstanceQuery()
                .taskAssignee(StartUser.getUserId().toString())
                .finished()
                .includeProcessVariables()
                .orderByTaskCreateTime().desc()
                .listPage((taskDTO.getPageNo() - 1) * taskDTO.getPageSize(), taskDTO.getPageSize());
        long count = historyService.createHistoricTaskInstanceQuery()
                .taskAssignee(StartUser.getUserId().toString()).count();
        List<TaskVO> taskVOS = new ArrayList<>();
        Page<TaskVO> page = new Page<>();
        for (HistoricTaskInstance task : tasks) {
            HistoricProcessInstance historicProcessInstance = historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            Boolean flag = historicProcessInstance.getEndTime() == null ? false : true;
            BpmnModel bpmnModel = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            Map<String, Object> processVariables = task.getProcessVariables();
            TaskVO taskVO = new TaskVO();
            taskVO.setTaskId(task.getId());
            taskVO.setProcessInstanceId(task.getProcessInstanceId());
            taskVO.setProcessDefinitionName(bpmnModel.getMainProcess().getName());
            taskVO.setStartUser(JSONObject.parseObject(MapUtil.getStr(processVariables, START_USER_INFO), new TypeReference<UserInfo>() {
            }));
            taskVO.setStartTime(historicProcessInstance.getStartTime());
            taskVO.setCurrentActivityName(getCurrentName(task.getProcessInstanceId(), flag, task.getProcessDefinitionId()));
            taskVO.setBusinessStatus(MapUtil.getStr(processVariables, PROCESS_STATUS));
            taskVO.setEndTime(task.getEndTime());

            long totalTimes = task.getEndTime() == null ?
                    (Calendar.getInstance().getTimeInMillis() - task.getStartTime().getTime()) :
                    (task.getEndTime().getTime() - task.getStartTime().getTime());
            long dayCount = totalTimes / (1000 * 60 * 60 * 24);//计算天
            long restTimes = totalTimes % (1000 * 60 * 60 * 24);//剩下的时间用于计于小时
            long hourCount = restTimes / (1000 * 60 * 60);//小时
            restTimes = restTimes % (1000 * 60 * 60);
            long minuteCount = restTimes / (1000 * 60);
            String spendTimes = dayCount + "天" + hourCount + "小时" + minuteCount + "分";
            taskVO.setDuration(spendTimes);
            taskVOS.add(taskVO);
        }

        page.setRecords(taskVOS);
        page.setCurrent(taskDTO.getPageNo());
        page.setSize(taskDTO.getPageSize());
        page.setTotal(count);
        return Result.OK(page);
    }


    @Override
    public ResponseResult revoke(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();
//        UserInfo currentUserInfo = handleDataDTO.getCurrentUserInfo();
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        HistoricTaskInstance task = historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        Map<String,Object> map=new HashMap<>();
        if(formData!=null &&formData.size()>0){
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR,formData);
        }
        map.put(PROCESS_STATUS,BUSINESS_STATUS_2);
        runtimeService.setVariables(task.getProcessInstanceId(),map);
        if(StringUtils.isNotBlank(comments)){
            taskService.addComment(task.getId(),task.getProcessInstanceId(),"opinion",comments);
        }
        if(attachments!=null && attachments.size()>0){
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option",taskId,task.getProcessInstanceId(),attachment.getName(),attachment.getName(),attachment.getUrl());
            }
        }

        if(StringUtils.isNotBlank(handleDataDTO.getSignInfo())){
            taskService.addComment(task.getId(),task.getProcessInstanceId(),"sign",handleDataDTO.getSignInfo());
        }
        runtimeService.deleteProcessInstance(task.getProcessInstanceId(),"撤销");
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,"");
    }
    @Override
    public ResponseResult agree(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();

        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        String processInstanceId=handleDataDTO.getProcessInstanceId();

        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        if (task!=null)//task为空则说明当前任务可能已结束
        {
            Map<String, Object> map = new HashMap<>();
            if (formData != null && formData.size() > 0) {
                Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
                });
                map.putAll(formValue);
                map.put(FORM_VAR, formData);
            }

            runtimeService.setVariables(task.getProcessInstanceId(), map);//设置进入当前流程
            Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
            if (StringUtils.isNotBlank(comments)) {
                taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
            }
            if (attachments != null && attachments.size() > 0) {
                for (AttachmentDTO attachment : attachments) {
                    taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
                }
            }

            if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
                taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
            }


            taskService.complete(task.getId());
            HistoricTaskInstance historicTask = historyService
                    .createHistoricTaskInstanceQuery()
                    .taskId(taskId)
                    .singleResult();

            if (historicTask.getEndTime()!=null)//EndTime为空，说明任务已结束，需要往消息队列中进行消息传递
            {
                HistoricProcessInstance historicProcessInstance= historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId)
                        .includeProcessVariables().singleResult();//拿到历史中的表单信息
                Map<String, Object> processVariables = historicProcessInstance.getProcessVariables();
                JSONObject jsonObject = (JSONObject) processVariables.get(FORM_VAR);


            }
            return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,"");

        }
        else {
            return new ResponseResult(HttpStatus.PROCESS_WAS_END,ReturnMsg.PROCESS_WAS_END,"");

        }


    }

    @Override
    public Result delegateTask(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();

        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }

        runtimeService.setVariables(task.getProcessInstanceId(), map);
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }

        UserInfo delegateUserInfo = handleDataDTO.getDelegateUserInfo();
        taskService.delegateTask(task.getId(), delegateUserInfo.getId());
        return Result.OK();
    }

    @Override
    public Result resolveTask(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();

        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }

        runtimeService.setVariables(task.getProcessInstanceId(), map);
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }

        taskService.resolveTask(taskId);
        return Result.OK();
    }

    @Override
    public ResponseResult refuse(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();

        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_3);
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }
        runtimeService.deleteProcessInstance(task.getProcessInstanceId(), "拒绝");

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,"");
    }


    @Override
    public Result assignee(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();

        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_1);
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }
        taskService.setAssignee(taskId, handleDataDTO.getTransferUserInfo().getId());
        return Result.OK();
    }

    @Override
    public Result rollback(HandleDataDTO handleDataDTO) {
        LoginUser StartUser= LoginContext.getContext().getLoginUser();
        Authentication.setAuthenticatedUserId(StartUser.getUserId().toString());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        String processInstanceId = handleDataDTO.getProcessInstanceId();
        List<Task> list = taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        Task task = null;
        List<String> taskIds = new ArrayList<>();

        for (Task task1 : list) {
            if (task1.getId().equals(taskId)) {
                task = task1;
            }
            taskIds.add(task1.getTaskDefinitionKey());
        }


        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_3);
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }


        runtimeService.createChangeActivityStateBuilder()
                .processInstanceId(task.getProcessInstanceId())
                .moveActivityIdsToSingleActivityId(taskIds, handleDataDTO.getRollbackId())
                .changeState();
        return Result.OK();
    }

    @Override
    public Result addMulti(HandleDataDTO handleDataDTO) {
        UserInfo currentUserInfo = handleDataDTO.getCurrentUserInfo();
        Authentication.setAuthenticatedUserId(currentUserInfo.getId());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_1);
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "opinion", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }

        Map<String, Object> variableMap = new HashMap<>();
        variableMap.put("assigneeName", handleDataDTO.getMultiAddUserInfo().getId());
        ExecutionEntity execution = (ExecutionEntity) runtimeService.addMultiInstanceExecution(task.getTaskDefinitionKey(), task.getProcessInstanceId(), variableMap);
        return Result.OK();
    }

    @Override
    public Result<List<MultiVO>> queryMultiUsersInfo(Map<String, Object> map) {
        String taskId = MapUtil.getStr(map, "taskId");
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        List<Task> list = taskService.createTaskQuery()
                .processInstanceId(task.getProcessInstanceId())
                .taskDefinitionKey(task.getTaskDefinitionKey()).list();
        Iterator<Task> iterator = list.iterator();
        List<MultiVO> multiVOList = new ArrayList<>();
        while (iterator.hasNext()) {
            Task next = iterator.next();
            if (!taskId.equals(next.getId())) {
                MultiVO multiVO = new MultiVO();
                multiVO.setTaskId(next.getId());
                multiVO.setProcessInstanceId(next.getProcessInstanceId());
                multiVO.setExecutionId(next.getExecutionId());
                multiVO.setUserId(next.getAssignee());
                multiVOList.add(multiVO);
            }

        }
        return Result.OK(multiVOList);
    }

    @Override
    public Result deleteMulti(List<String> executionIds) {
        for (String executionId : executionIds) {
            runtimeService.deleteMultiInstanceExecution(executionId, true);
        }
        return Result.OK();
    }

    @Override
    public Result comments(HandleDataDTO handleDataDTO) {
        UserInfo currentUserInfo = handleDataDTO.getCurrentUserInfo();
        Authentication.setAuthenticatedUserId(currentUserInfo.getId());
        List<AttachmentDTO> attachments = handleDataDTO.getAttachments();
        String comments = handleDataDTO.getComments();
        JSONObject formData = handleDataDTO.getFormData();
        String taskId = handleDataDTO.getTaskId();
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        Map<String, Object> map = new HashMap<>();
        if (formData != null && formData.size() > 0) {
            Map formValue = JSONObject.parseObject(formData.toJSONString(), new TypeReference<Map>() {
            });
            map.putAll(formValue);
            map.put(FORM_VAR, formData);
        }
        map.put(PROCESS_STATUS, BUSINESS_STATUS_1);
        runtimeService.setVariables(task.getProcessInstanceId(), map);
        if (StringUtils.isNotBlank(comments)) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "comments", comments);
        }
        if (attachments != null && attachments.size() > 0) {
            for (AttachmentDTO attachment : attachments) {
                taskService.createAttachment("option", taskId, task.getProcessInstanceId(), attachment.getName(), attachment.getName(), attachment.getUrl());
            }
        }

        if (StringUtils.isNotBlank(handleDataDTO.getSignInfo())) {
            taskService.addComment(task.getId(), task.getProcessInstanceId(), "sign", handleDataDTO.getSignInfo());
        }
        return Result.OK();
    }

    @Override
    public Result<HandleDataVO> instanceInfo(HandleDataDTO HandleDataDTO) {
        String processInstanceId = HandleDataDTO.getProcessInstanceId();
        HistoricProcessInstance historicProcessInstance = historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId)
                .includeProcessVariables().singleResult();
        String processDefinitionKey = historicProcessInstance.getProcessDefinitionKey();
        ProcessTemplates processTemplates = processTemplateService.getById(processDefinitionKey.replace(PROCESS_PREFIX, ""));
//        processTemplates.setLogo(processTemplates.getIcon());
        processTemplates.setFormId(processTemplates.getTemplateId());
        processTemplates.setFormName(processTemplates.getFormName());
//        processTemplates.setProcessDefinitionId(historicProcessInstance.getProcessDefinitionId());

        HandleDataVO handleDataVO = new HandleDataVO();
        Map<String, Object> processVariables = historicProcessInstance.getProcessVariables();

        handleDataVO.setProcessInstanceId(historicProcessInstance.getId());
        JSONObject jsonObject = (JSONObject) processVariables.get(FORM_VAR);
        handleDataVO.setFormData(jsonObject);
        String process = processTemplates.getProcessJson();
        ChildNode childNode = JSONObject.parseObject(process, new TypeReference<ChildNode>() {
        });
        SettingsInfo settingsInfo = JSONObject.parseObject(processTemplates.getSettings(), new TypeReference<SettingsInfo>() {
        });
        Boolean sign = settingsInfo.getSign();
        ChildNode currentNode = null;
        if (StringUtils.isNotBlank(HandleDataDTO.getTaskId())) {
            HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery().taskId(HandleDataDTO.getTaskId()).singleResult();
            currentNode = getChildNode(childNode, historicTaskInstance.getTaskDefinitionKey());
            List<FormOperates> formPerms = currentNode.getProps().getFormPerms();
            if (CollUtil.isNotEmpty(formPerms)) {
                Iterator<FormOperates> iterator = formPerms.iterator();
                while (iterator.hasNext()) {
                    FormOperates next = iterator.next();
                    if ("H".equals(next.getPerm())) {
                        iterator.remove();
                        if (jsonObject != null) {
                            jsonObject.remove(next.getId());
                        }
                    }
                }
            }
            handleDataVO.setCurrentNode(currentNode);
            handleDataVO.setTaskId(HandleDataDTO.getTaskId());
        }

        if (sign) {
            handleDataVO.setSignFlag(true);
        }
        if (StringUtils.isNotBlank(HandleDataDTO.getTaskId())) {
            if (currentNode != null) {
                if (currentNode.getProps().getSign()) {
                    handleDataVO.setSignFlag(true);
                } else {
                    handleDataVO.setSignFlag(false);
                }
            }
        }

        List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(historicProcessInstance.getId()).list();
        Map<String, List<HistoricActivityInstance>> historicActivityInstanceMap = new HashMap<>();
        for (HistoricActivityInstance historicActivityInstance : list) {
            List<HistoricActivityInstance> historicActivityInstances = historicActivityInstanceMap.get(historicActivityInstance.getActivityId());
            if (historicActivityInstances == null) {
                historicActivityInstances = new ArrayList<>();
                historicActivityInstances.add(historicActivityInstance);
                historicActivityInstanceMap.put(historicActivityInstance.getActivityId(), historicActivityInstances);
            } else {
                historicActivityInstances.add(historicActivityInstance);
                historicActivityInstanceMap.put(historicActivityInstance.getActivityId(), historicActivityInstances);
            }
        }

        Process mainProcess = repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId()).getMainProcess();
        Collection<FlowElement> flowElements = mainProcess.getFlowElements();

        List<String> runningList = new ArrayList<>();
        handleDataVO.setRunningList(runningList);
        List<String> endList = new ArrayList<>();
        handleDataVO.setEndList(endList);
        List<String> noTakeList = new ArrayList<>();
        handleDataVO.setNoTakeList(noTakeList);
        Map<String, List<TaskDetailVO>> deatailMap = new HashMap<>();
        List<Comment> processInstanceComments = taskService.getProcessInstanceComments(historicProcessInstance.getId());
        List<Attachment> processInstanceAttachments = taskService.getProcessInstanceAttachments(historicProcessInstance.getId());
        for (FlowElement flowElement : flowElements) {
            List<TaskDetailVO> detailVOList = new ArrayList<>();
            List<HistoricActivityInstance> historicActivityInstanceList = historicActivityInstanceMap.get(flowElement.getId());
            if (CollUtil.isNotEmpty(historicActivityInstanceList)) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstanceList) {
                    if (historicActivityInstance.getEndTime() != null) {
                        if ("startEvent".equalsIgnoreCase(historicActivityInstance.getActivityType()) || "endEvent".equalsIgnoreCase(historicActivityInstance.getActivityType())) {
                            TaskDetailVO taskDetailVO = new TaskDetailVO();
                            taskDetailVO.setActivityId(historicActivityInstance.getActivityId());
                            taskDetailVO.setName(historicActivityInstance.getActivityName());
                            taskDetailVO.setCreateTime(historicActivityInstance.getStartTime());
                            taskDetailVO.setEndTime(historicActivityInstance.getEndTime());
                            detailVOList.add(taskDetailVO);
                            deatailMap.put(historicActivityInstance.getActivityId(), detailVOList);
                            endList.add(historicActivityInstance.getActivityId());
                        } else if ("userTask".equalsIgnoreCase(historicActivityInstance.getActivityType())) {
                            List<TaskDetailVO> voList = deatailMap.get(historicActivityInstance.getActivityId());
                            List<HistoricActivityInstance> activityInstanceList = list.stream().filter(h -> h.getActivityId().equals(historicActivityInstance.getActivityId()) && h.getEndTime() != null).collect(Collectors.toList());
                            if (voList != null) {
                                collectUserTaskInfo(processInstanceComments, processInstanceAttachments, historicActivityInstance, voList, activityInstanceList);
                            } else {
                                voList = new ArrayList<>();
                                collectUserTaskInfo(processInstanceComments, processInstanceAttachments, historicActivityInstance, voList, activityInstanceList);
                            }
                            deatailMap.put(historicActivityInstance.getActivityId(), voList);
                            endList.add(historicActivityInstance.getActivityId());
                        } else if ("serviceTask".equalsIgnoreCase(historicActivityInstance.getActivityType())) {

                        }
                    } else {
                        if ("userTask".equalsIgnoreCase(historicActivityInstance.getActivityType())) {
                            List<TaskDetailVO> voList = deatailMap.get(historicActivityInstance.getActivityId());
                            List<HistoricActivityInstance> activityInstanceList = list.stream().filter(h -> h.getActivityId().equals(historicActivityInstance.getActivityId()) && h.getEndTime() == null).collect(Collectors.toList());
                            if (voList != null) {
                                collectUserTaskInfo(processInstanceComments, processInstanceAttachments, historicActivityInstance, voList, activityInstanceList);
                            } else {
                                voList = new ArrayList<>();
                                collectUserTaskInfo(processInstanceComments, processInstanceAttachments, historicActivityInstance, voList, activityInstanceList);
                            }
                            deatailMap.put(historicActivityInstance.getActivityId(), voList);
                            if (endList.contains(historicActivityInstance.getActivityId())) {
                                endList.remove(historicActivityInstance.getActivityId());
                                runningList.add(historicActivityInstance.getActivityId());
                            } else {
                                runningList.add(historicActivityInstance.getActivityId());
                            }
                        } else if ("serviceTask".equalsIgnoreCase(historicActivityInstance.getActivityType())) {

                        }
                    }
                }
            } else {
                noTakeList.add(flowElement.getId());
            }
        }
        handleDataVO.setProcessTemplates(processTemplates);
        handleDataVO.setDetailVOList(deatailMap);
        return Result.OK(handleDataVO);
    }

    private void collectUserTaskInfo(List<Comment> processInstanceComments,
                                     List<Attachment> processInstanceAttachments,
                                     HistoricActivityInstance historicActivityInstance,
                                     List<TaskDetailVO> voList,
                                     List<HistoricActivityInstance> activityInstanceList) {
        for (HistoricActivityInstance activityInstance : activityInstanceList) {
            TaskDetailVO taskDetailVO = new TaskDetailVO();
            taskDetailVO.setTaskId(activityInstance.getTaskId());
            taskDetailVO.setActivityId(activityInstance.getActivityId());
            taskDetailVO.setName(activityInstance.getActivityName());
            taskDetailVO.setCreateTime(activityInstance.getStartTime());
            taskDetailVO.setEndTime(activityInstance.getEndTime());
            Comment signComment = processInstanceComments.stream().filter(h -> h.getTaskId().equals(historicActivityInstance.getTaskId()) && h.getType().equals("sign")).findFirst().orElse(null);
            if (signComment != null) {
                taskDetailVO.setSignImage(signComment.getFullMessage());
            }
            List<Attachment> attachments = processInstanceAttachments.stream().filter(h -> h.getTaskId().equals(historicActivityInstance.getTaskId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(attachments)) {
                List<AttachmentVO> attachmentVOList = new ArrayList<>();
                for (Attachment attachment : attachments) {
                    AttachmentVO attachmentVO = new AttachmentVO();
                    attachmentVO.setId(attachment.getId());
                    attachmentVO.setName(attachment.getName());
                    attachmentVO.setUrl(attachment.getUrl());
                    attachmentVOList.add(attachmentVO);
                }
                taskDetailVO.setAttachmentVOList(attachmentVOList);
            }

            List<Comment> options = processInstanceComments.stream().filter(h -> h.getTaskId().equals(historicActivityInstance.getTaskId()) && h.getType().equals("opinion")).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(options)) {
                List<OptionVO> optionVOList = new ArrayList<>();
                for (Comment option : options) {
                    OptionVO optionVO = new OptionVO();
                    optionVO.setComments(option.getFullMessage());
                    optionVO.setUserId(option.getUserId());
//                                        optionVO.setUserName();
                    optionVO.setCreateTime(option.getTime());
                    optionVOList.add(optionVO);
                }
                taskDetailVO.setOptionVOList(optionVOList);
            }

            List<Comment> comments = processInstanceComments.stream().filter(h -> h.getTaskId().equals(historicActivityInstance.getTaskId()) && h.getType().equals("comments")).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(comments)) {
                List<CommentVO> commentsVOList = new ArrayList<>();
                for (Comment comment : comments) {
                    CommentVO commentVO = new CommentVO();
                    commentVO.setComments(comment.getFullMessage());
                    commentVO.setUserId(comment.getUserId());
//                                        commentVO.setUserName();
                    commentVO.setCreateTime(comment.getTime());
                    commentsVOList.add(commentVO);
                }
                taskDetailVO.setCommentVOList(commentsVOList);
            }

            voList.add(taskDetailVO);


        }
    }

    private String getCurrentName(String processInstanceId, Boolean flag, String processDefinitionId) {
        if (flag) {
            return "流程已结束";
        }
        Execution execution = runtimeService.createExecutionQuery().executionId(processInstanceId).singleResult();
        String activityId = execution.getActivityId();
        if (StringUtils.isBlank(activityId)) {
            return "";
        } else {
            BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(activityId);
            return flowElement.getName();
        }

    }

}
