package com.junmp.junmpProcess.listener;

import com.junmp.junmpProcess.utils.RabbitMQUtils2;
//import com.rabbitmq.client.Channel;
//import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MessageProperties;
import lombok.SneakyThrows;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.impl.event.FlowableEntityEventImpl;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GlobalEndListener extends AbstractFlowableEngineEventListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
    * @Author: Zhaojw
    * @Description: 流程结束监听
    * @DateTime: 2023/6/27 13:21
    * @Params:
    * @Return
    */
    @SneakyThrows
    @Override
    protected void processCompleted(FlowableEngineEntityEvent event) {
            //流程结束后工作在这里写
            //得到流程定义id
            String processDefinitionId = event.getProcessDefinitionId();
            //得到流程实例id
            String processInstanceId = event.getProcessInstanceId();
        /**
         * 生产者不需要绑定队列和交换机，只有生产者才需要
         *
         * 建立连接
         * 建立通道
         * 推送消息
         */

        Connection connection = RabbitMQUtils2.getConnection();
        Channel channel = connection.createChannel();
        channel.queueDeclare("info",false,false,false,null);
        channel.basicPublish("", "info", MessageProperties.PERSISTENT_TEXT_PLAIN,("publish").getBytes());

        RabbitMQUtils2.closeChannelAndConnection(connection,channel);
    }

}
