package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.WarehouseAreaReq;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.bean.req.WarehouseReq;
import com.junmp.jyzb.api.exception.enums.WarehouseExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
@Slf4j
public class WarehouseServiceImpl extends ServiceImpl<WarehouseMapper,Warehouse> implements WarehouseService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private WarehouseMapper warehouseMapper;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private ShelfMapper shelfMapper;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private WarehouseAreaMapper areaMapper;

    private static final String REDIS_WAREHOUSE = "Warehouse_";

    //@Override
    public ResponseResult addWarehouse(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(msg.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该组织机构不存在");
        }

        Warehouse warehouse =new Warehouse();
        //将警员相关信息添加到警员表
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        warehouse.setId(uuid);
        warehouse.setCreateTime(currentDate);
        warehouse.setUpdateTime(currentDate);

        warehouse.setName((String) msg.get("name"));
        //warehouse.setUpdateUser((String) msg.get("updateUser"));
        warehouse.setLocation((String) msg.get("location"));
        warehouse.setPhone((String) msg.get("phone"));
        warehouse.setOrgId((String) msg.get("orgId"));
        warehouse.setVideo((String) msg.get("video"));
        warehouseMapper.addWarehouse(warehouse);

        // 将uuid、创建时间、更新时间加入到policeman中
        msg.put("id",uuid);
        long timestamp = currentDate.getTime(); // 将Date对象转换为long类型的时间戳
        msg.put("updateTime",timestamp);

        /**
         * 更新缓存
         * */
        //构建Redis缓存键
        String redisKey = REDIS_WAREHOUSE + "true" +'_'+ msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedDataTrue = redisUtils.findCachedData(redisKey);
        if (cachedDataTrue != null) {
            cachedDataTrue.add(0,msg);
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, cachedDataTrue);
        }

        //构建Redis缓存键
        redisKey = REDIS_WAREHOUSE + "false" +'_'+ msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedDataFalse = redisUtils.findCachedData(redisKey);
        if (cachedDataFalse != null) {
            cachedDataFalse.add(0,msg);
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, cachedDataFalse);
        }

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,uuid);
    }

    @Override
    public boolean addWarehouse(WarehouseReq req) {
        Warehouse warehouse = new Warehouse();
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.save(warehouse);
    }

    @Override
    public Warehouse getOneWarehouse(WarehouseReq req) {

        Warehouse warehouseMsg=this.getById(req.getId());
        if (warehouseMsg == null) {
            return null;
        }
        // 填充其他关联信息的字段和对象引用
        return warehouseMsg;
    }

    //@Override
    public ResponseResult getOneWarehouse(Map<String, Object> id) {
        try {
            checkNotBlank(id.get("warehouseId"), "warehouseId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String warehouseId = id.get("warehouseId").toString();
        Map<String, Object> warehouse = warehouseMapper.getOneWarehouse(warehouseId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,warehouse);
    }



    //@Override
    public ResponseResult deleteWarehouse(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("warehouseList"), "warehouseList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        List<Object> warehouseList = (List<Object>) msg.get("warehouseList");
        for (Object warehouseId:warehouseList){
            warehouseMapper.deleteWarehouse(warehouseId.toString());
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public boolean deleteWarehouse(WarehouseReq req) {
        this.removeById(req.getId());
        return true;
    }

    @Override
    public boolean updateWarehouse(WarehouseReq req) {
        Warehouse warehouse = this.queryWarehouse(req);
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.updateById(warehouse);
    }

    //@Override
    public ResponseResult updateWarehouse(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(msg.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该组织机构不存在");
        }

        Warehouse warehouse =new Warehouse();
        //修改警员相关信息
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        warehouse.setUpdateTime(currentDate);

        //police.setId(uuid);
        warehouse.setId((String) msg.get("warehouseId"));
        warehouse.setName((String) msg.get("name"));
        //warehouse.setUpdateUser((String) msg.get("updateUser"));
        warehouse.setLocation((String) msg.get("location"));
        warehouse.setPhone((String) msg.get("phone"));
        warehouse.setOrgId((String) msg.get("orgId"));

        warehouseMapper.updateWarehouse(warehouse);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }

    //@Override
    public ResponseResult changeWarehouseState(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
            Objects.requireNonNull(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        Warehouse warehouse =new Warehouse();
        warehouse.setId(msg.get("warehouseId").toString());
        warehouse.setState((Integer) msg.get("state"));
        warehouseMapper.changeWarehouseState(warehouse);

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public List<Warehouse> getAllWarehouse(WarehouseReq msg) {
//        Warehouse warehouse = new Warehouse();
//        BeanPlusUtil.copyProperties(msg, warehouse);
//
        List<Warehouse> allWarehouse=new ArrayList<>();

        //如果组织机构是浙江省公安厅
        if (msg.getOrgId().equals(1369509498032808905l) && msg.getIncludeLowerLevel().equals("true")){
            allWarehouse = this.list();
            return allWarehouse;
        }

        //获取组织机构Id
        List<String> allOrgId =getAllOrgId(msg);

        //根据获取的组织机构查询警员信息
        allWarehouse = getAllWarehouseByOrg(allOrgId);

        return allWarehouse;
    }

    //@Override
    public boolean addArea(WarehouseAreaReq msg) {
        return false;
    }

    private List<String> getAllOrgId(WarehouseReq msg) {
        List<String> allOrg = new ArrayList<>();
        if (msg.getIncludeLowerLevel().equals("false")){
            allOrg.add(msg.getOrgId().toString());
        }else if(msg.getIncludeLowerLevel().equals("true")){
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(msg.getOrgId().toString());
        }
        return allOrg;
    }

    private List<Warehouse> getAllWarehouseByOrg(List<String> allOrgId) {
        List<Warehouse> allWarehouse = new ArrayList<>();

        LambdaQueryWrapper<Warehouse> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(Warehouse::getOrgIdInt, allOrgId);

        allWarehouse = warehouseMapper.selectList(queryWrapper);
        return allWarehouse;
    }

    //@Override
    public ResponseResult addArea(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的warehouseId是否存在
        Map<String,Object> oneWarehouse = warehouseMapper.getOneWarehouse(msg.get("warehouseId").toString());
        if (oneWarehouse == null || oneWarehouse.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该仓库不存在");
        }

        WarehouseArea warehouseArea =new WarehouseArea();

        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        warehouseArea.setId(uuid);
        warehouseArea.setCreateTime(currentDate);
        warehouseArea.setUpdateTime(currentDate);

        warehouseArea.setAreaName((String) msg.get("name"));
        warehouseArea.setWarehouseId((String) msg.get("warehouseId"));
        warehouseArea.setPhoto((String) msg.get("photo"));

        areaMapper.addArea(warehouseArea);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,uuid);
    }

    //@Override
    public ResponseResult updateArea(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("areaId"), "areaId不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的warehouseId是否存在
        Map<String,Object> oneWarehouse = warehouseMapper.getOneWarehouse(msg.get("warehouseId").toString());
        if (oneWarehouse == null || oneWarehouse.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该仓库不存在");
        }

        WarehouseArea warehouseArea =new WarehouseArea();
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        warehouseArea.setUpdateTime(currentDate);

        warehouseArea.setId((String) msg.get("areaId"));
        warehouseArea.setAreaName((String) msg.get("name"));
        warehouseArea.setWarehouseId((String) msg.get("warehouseId"));
        warehouseArea.setPhoto((String) msg.get("photo"));

        areaMapper.updateArea(warehouseArea);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult deleteArea(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("areaId"), "areaId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String areaId = msg.get("areaId").toString();
        areaMapper.deleteArea(areaId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult getAreaList(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        Shelf shelf =new Shelf();
        shelf.setWarehouseId((String) msg.get("warehouseId"));
        List<Map<String,Object>> areaList = areaMapper.getAreaList(shelf);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,areaList);
    }

    //@Override
    public ResponseResult addShelf(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("shelfName"), "shelfName不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("type"), "type不能为空");
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
            checkNotBlank(msg.get("shelfRows"), "shelfRows不能为空");
            checkNotBlank(msg.get("shelfColumns"), "shelfColumns不能为空");
            checkNotBlank(msg.get("shelfRanges"), "shelfRanges不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的warehouseId是否存在
        Map<String,Object> oneWarehouse = warehouseMapper.getOneWarehouse(msg.get("warehouseId").toString());
        if (oneWarehouse == null || oneWarehouse.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该仓库不存在");
        }

        Shelf shelf =new Shelf();
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        shelf.setShelfId(uuid);
        shelf.setCreateTime(currentDate);
        shelf.setUpdateTime(currentDate);

        shelf.setShelfName((String) msg.get("shelfName"));
        shelf.setCode((String) msg.get("code"));
        shelf.setType((String) msg.get("type"));
        shelf.setWarehouseId((String) msg.get("warehouseId"));
        shelf.setShelfRows((Integer) msg.get("shelfRows"));
        shelf.setShelfColumns((Integer) msg.get("shelfColumns"));
        shelf.setShelfRanges((Integer) msg.get("shelfRanges"));
        shelf.setUrl((String) msg.get("url"));
        shelf.setSizeInfo((String) msg.get("sizeInfo"));

        shelfMapper.addShelf(shelf);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,uuid);
    }

    //@Override
    public ResponseResult updateShelf(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("shelfId"), "shelfId不能为空");
            checkNotBlank(msg.get("shelfName"), "shelfName不能为空");
            checkNotBlank(msg.get("code"), "code不能为空");
            checkNotBlank(msg.get("type"), "type不能为空");
            checkNotBlank(msg.get("shelfRows"), "shelfRows不能为空");
            checkNotBlank(msg.get("shelfColumns"), "shelfColumns不能为空");
            checkNotBlank(msg.get("shelfRanges"), "shelfRanges不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        Shelf shelf =new Shelf();
        //生成一个uuid
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        shelf.setUpdateTime(currentDate);

        shelf.setShelfId((String) msg.get("shelfId"));
        shelf.setShelfName((String) msg.get("shelfName"));
        shelf.setCode((String) msg.get("code"));
        shelf.setType((String) msg.get("type"));
        shelf.setShelfRows((Integer) msg.get("shelfRows"));
        shelf.setShelfColumns((Integer) msg.get("shelfColumns"));
        shelf.setShelfRanges((Integer) msg.get("shelfRanges"));
        shelf.setUrl((String) msg.get("url"));
        shelf.setSizeInfo((String) msg.get("sizeInfo"));

        shelfMapper.updateShelf(shelf);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult deleteShelf(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("shelfId"), "shelfId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String shelfId = msg.get("shelfId").toString();

        shelfMapper.deleteShelf(shelfId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    //@Override
    public ResponseResult getShelfList(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("warehouseId"), "warehouseId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        Shelf shelf =new Shelf();
        shelf.setWarehouseId((String) msg.get("warehouseId"));
        List<Map<String,Object>> areaList = shelfMapper.getShelfList(shelf);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,areaList);
    }

    @Override
    public List<String> getAllWarehouseId(Map<String, Object> msg) {
        //如果组织机构是最高级的，获取所有id
        if (msg.get("orgId").toString().equals("1369509498032808905")){
            //构建 Redis 缓存键
            String redisKey = "getAllWarehouseId_"+msg.get("orgId");
            // 从 Redis 中获取数据
            List<String> cachedData = redisUtils.findCachedData(redisKey);
            if (cachedData!=null){
                return cachedData;
            }
            List<String> allWarehouseId = warehouseMapper.getAllWarehouseIdByHighest();
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, allWarehouseId);
            return allWarehouseId;
        }

        //构建 Redis 缓存键
        String redisKey = "getAllWarehouseId_"+msg.get("IncludeLowerLevel")+'_'+msg.get("orgId");
        // 从 Redis 中获取数据
        List<String> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData!=null){
            return cachedData;
        }
        List<String> warehouseId =new ArrayList<>();
        if (!msg.containsKey("IncludeLowerLevel")){
            warehouseId = warehouseMapper.getAllWarehouseId(msg.get("orgId").toString());
        }
        else if(msg.get("IncludeLowerLevel").equals("false")){
            warehouseId = warehouseMapper.getAllWarehouseId(msg.get("orgId").toString());
        }else {
            //warehouseId = warehouseMapper.getAllWarehouseId(msg.get("orgId").toString());
            List<String> orgIds = getSubIds(msg.get("orgId").toString()); //调用本级及下级的所有组织机构的id
            for (String orgId:orgIds){
                List<String> allPoliceId = warehouseMapper.getAllWarehouseId(orgId);
                warehouseId.addAll(allPoliceId);
            }
        }
        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, warehouseId);
        return warehouseId;
    }

    @Override
    public boolean changeWarehouseState(WarehouseReq req) {
        Warehouse warehouse = this.queryWarehouse(req);
        BeanPlusUtil.copyProperties(req, warehouse);
        return this.updateById(warehouse);
    }

    @Override
    public ResponseResult setWarehouseInventory(Map<String, Object> msg) {
        String id;
        if (msg.containsKey("locationId") && msg.get("locationId")!=""){
            id = msg.get("locationId").toString();
        }else {
            id = null;
        }
        //统计仓库 装备总数
        warehouseMapper.setWarehouseSumInventory(id);
        //统计仓库 装备在库总数
        warehouseMapper.setWarehouseInSumInventory(id);
        //统计仓库 装备出库总数
        warehouseMapper.setWarehouseOutSumInventory(id);
        //统计仓库 装备出库总数
        warehouseMapper.setWarehousePriceInventory(id);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    private Warehouse queryWarehouse(WarehouseReq req) {
        Warehouse app = this.getById(req.getId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(WarehouseExceptionEnum.WAREHOUSE_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<Product> createWrapper(ProductReq req) {
        LambdaQueryWrapper<Product> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getProductCode()), Product::getProductCode, req.getProductCode());
        //根据企业名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()), Product::getName, req.getName());
        wrapper.orderByDesc(Product::getUpdateTime);
        return wrapper;
    }
}
