package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.bean.req.WarehouseAreaReq;
import com.junmp.jyzb.api.exception.enums.ProductExceptionEnum;
import com.junmp.jyzb.api.exception.enums.WarehouseAreaExceptionEnum;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.entity.Warehouse;
import com.junmp.jyzb.entity.WarehouseArea;
import com.junmp.jyzb.mapper.ProductMapper;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.WarehouseAreaMapper;
import com.junmp.jyzb.service.WarehouseAreaService;

import java.util.List;

@Service
public class WarehouseAreaServiceImpl extends ServiceImpl<WarehouseAreaMapper, WarehouseArea> implements WarehouseAreaService{

    @Resource
    private WarehouseAreaMapper warehouseAreaMapper;


    @Override
    public boolean addArea(WarehouseAreaReq req) {
        WarehouseArea area = new WarehouseArea();
        BeanPlusUtil.copyProperties(req, area);
        return this.save(area);
    }

    @Override
    public boolean updateArea(WarehouseAreaReq req) {
        WarehouseArea area = this.queryWarehouseArea(req);
        BeanPlusUtil.copyProperties(req, area);
        return this.updateById(area);
    }

    @Override
    public boolean deleteArea(WarehouseAreaReq req) {
        WarehouseArea warehouseArea = queryWarehouseArea(req);
        this.removeById(req.getId());
        return true;
    }

    @Override
    public List<WarehouseArea> getAreaList(WarehouseAreaReq req) {
        LambdaQueryWrapper<WarehouseArea> wrapper = createWrapper(req);
        return this.list(wrapper);
    }

    private WarehouseArea queryWarehouseArea(WarehouseAreaReq req) {
        WarehouseArea app = this.getById(req.getId());

        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(WarehouseAreaExceptionEnum.WAREHOUSEAREA_NOT_EXIST);
        }
        return app;
    }

    private LambdaQueryWrapper<WarehouseArea> createWrapper(WarehouseAreaReq req) {
        LambdaQueryWrapper<WarehouseArea> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据地区id查询
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()), WarehouseArea::getId, req.getId());
        //根据地区名称模糊查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getAreaName()), WarehouseArea::getAreaName, req.getAreaName());
        wrapper.orderByDesc(WarehouseArea::getCreateTime);
        return wrapper;
    }
}
