package com.junmp.jyzb.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.api.bean.req.PolicemanReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.PoliceFinger;
import com.junmp.jyzb.exception.enums.PolicemanExceptionEnum;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import com.junmp.jyzb.entity.Policeman;

import javax.annotation.Resource;
import java.util.*;


import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
@Slf4j
public class PolicemanServiceImpl extends ServiceImpl<PolicemanMapper, Policeman> implements PolicemanService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PoliceFingerMapper policeFingerMapper;

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private CabinetMapper cabinetMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;

    @Resource
    private CabinetService cabinetService;

    @Resource
    private PolicemanService policemanService;

    private static final String REDIS_POLICE = "Policeman_";
    private static final String REDIS_ORG = "Organization_";

    @Override
    public ResponseResult addPoliceman(Map<String, Object> policeman) {
        // 进行参数校验
        try {
            checkNotBlank(policeman.get("orgId"), "orgId不能为空");
            checkNotBlank(policeman.get("name"), "name不能为空");
            checkNotBlank(policeman.get("policeCode"), "policeCode不能为空");
            checkNotBlank(policeman.get("sex"),"sex不能为空");
            //checkNotBlank((String) policeman.get("cabinetBoxId"), "cabinetBoxId不能为空");
            checkNotBlank(policeman.get("phone"), "phone不能为空");
            checkNotBlank(policeman.get("idCard"), "idCard不能为空");
            //checkNotBlank((String) policeman.get("photo"), "photo不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(policeman.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该组织机构不存在");
        }

        //查询是否有重复的policeCode
        List<String> policeCodeFlag = policemanMapper.getPoliceByPoliceCode((String) policeman.get("policeCode"));
        if (!policeCodeFlag.isEmpty()){
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"警员编号已存在");
        }

        //todo cabinetBoxId能否重复


        //查询单警柜箱号是否存在
        if (policeman.containsKey("cabinetBoxId") && policeman.get("cabinetBoxId").toString()!=""){ //如果cabinetBoxId的存在且值不为空
            String oneCabinetBox = cabinetBoxMapper.getOneCabinetBox(policeman.get("cabinetBoxId").toString());
            if (oneCabinetBox == null || oneCabinetBox.equals("")){
                return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该单警柜箱号不存在");
            }
        }

        Policeman police =new Policeman();
        //将警员相关信息添加到警员表
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        police.setCreateTime(currentDate);
        police.setUpdateTime(currentDate);
        police.setId(uuid);

        police.setOrgId((Long) policeman.get("orgId"));
        police.setName((String) policeman.get("name"));
        police.setPoliceCode((String) policeman.get("policeCode"));
        police.setSex((String) policeman.get("sex"));
        police.setCabinetBoxId((String) policeman.get("cabinetBoxId"));
        police.setPhone((String) policeman.get("phone"));
        police.setIdCard((String) policeman.get("idCard"));
        police.setPhoto((String) policeman.get("photo"));

        policemanMapper.addPoliceman(police);

//        // 将uuid、创建时间、更新时间加入到policeman中
//        policeman.put("id",uuid);
//        long timestamp = currentDate.getTime(); // 将Date对象转换为long类型的时间戳
//        policeman.put("updateTime",timestamp);
//
//        /**
//         * 更新缓存
//         * */
//        //构建Redis缓存键
//        String redisKey = REDIS_ORG + "true" +'_'+ policeman.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedDataTrue = redisUtils.findCachedData(redisKey);
//        if (cachedDataTrue != null) {
//            cachedDataTrue.add(0,policeman);
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, cachedDataTrue);
//        }
//
//        //构建Redis缓存键
//        redisKey = REDIS_ORG + "false" +'_'+ policeman.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedDataFalse = redisUtils.findCachedData(redisKey);
//        if (cachedDataFalse != null) {
//            cachedDataFalse.add(0,policeman);
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, cachedDataFalse);
//        }

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,uuid);
    }

    // 更新缓存的方法，新增警员信息时调用
    private void updatePoliceIdCache(String orgId, String newPoliceId) {
        // 构建 Redis 缓存键
        String redisKeyFalse = "getAllPoliceId_false_" + orgId;
        String redisKeyTrue = "getAllPoliceId_true_" + orgId;

        // 从 Redis 中获取旧的缓存数据
        List<String> cachedDataFalse = redisUtils.findCachedData(redisKeyFalse);
        List<String> cachedDataTrue = redisUtils.findCachedData(redisKeyTrue);

        //如果缓存中没有数据，则直接查询数据库并更新Redis缓存
        //如果缓存中有数据，就更新数据
        if (cachedDataFalse == null && cachedDataTrue == null) {
            //getAllPoliceId(Map.of("IncludeLowerLevel", false, "orgId", orgId));
            return;
        }else if(cachedDataFalse!=null){
            cachedDataFalse.add(newPoliceId);
            redisUtils.set(redisKeyFalse, cachedDataFalse);
        }else if(cachedDataTrue!=null){
            cachedDataTrue.add(newPoliceId);
            redisUtils.set(redisKeyTrue, cachedDataTrue);
        }
    }

    //删除缓存的方法
    private void deletePoliceIdCache(String orgId){
        //构建 Redis 缓存键
        String redisKey = "getAllPoliceId_false_" + orgId;
        redisUtils.delete(redisKey);

        //构建 Redis 缓存键
        redisKey = "getAllPoliceId_true_" + orgId;
        redisUtils.delete(redisKey);
    }

    @Override
    public ResponseResult getOnePolice(Map<String, Object> msg){
        // 进行参数校验
        try {
            checkNotBlank(msg.get("policeId"), "policeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        String userId = msg.get("policeId").toString();
        Map<String, Object> policeMsg = policemanMapper.getOnePolice(userId);
        //如果没有查找到信息，返回相关提示
        if (policeMsg == null){
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.NO_DATA, ReturnData.NO_DATA);
        }
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,policeMsg);
    }

    @Override
    public ResponseResult deletePolice(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("policeList"), "policeList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //遍历要删除的警员id
        List<Object> policeList = (List<Object>) msg.get("policeList");
        for (Object policeId:policeList){
            policemanMapper.deletePolice(policeId.toString());
        }

        //todo 删除缓存中的警员信息

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public ResponseResult updatePolice(Map<String, Object> policeman) {
        // 进行参数校验
        try {
            checkNotBlank(policeman.get("id"), "id不能为空");
            checkNotBlank(policeman.get("orgId"), "orgId不能为空");
            checkNotBlank(policeman.get("name"), "name不能为空");
            checkNotBlank(policeman.get("policeCode"), "policeCode不能为空");
            checkNotBlank(policeman.get("sex"), "sex不能为空");
            //checkNotBlank((String) policeman.get("cabinetBoxId"), "cabinetBoxId不能为空");
            checkNotBlank(policeman.get("phone"), "phone不能为空");
            checkNotBlank(policeman.get("idCard"), "idCard不能为空");
            //checkNotBlank((String) policeman.get("photo"), "photo不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(policeman.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该组织机构不存在");
        }

        //获取map中的policeCode
        String policeCode = policeman.get("policeCode").toString();

        //查询是否有重复的policeCode
        List<String> policeCodeFlag = policemanMapper.getPoliceByPoliceCode(policeCode);
        //判断policeCode是否有变动
        String oldPoliceCode = policemanMapper.getPoliceCodeById(policeman.get("id").toString());
        if (oldPoliceCode!=null && !oldPoliceCode.equals(policeCode)){
            if (!policeCodeFlag.isEmpty()){
                return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"警员编号已存在");
            }
        }

        //查询单警柜箱号是否存在
        if (policeman.containsKey("cabinetBoxId") && policeman.get("cabinetBoxId").toString()!=""){
            String oneCabinetBox = cabinetBoxMapper.getOneCabinetBox(policeman.get("cabinetBoxId").toString());
            if (oneCabinetBox == null || oneCabinetBox.equals("")){
                return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"该单警柜箱号不存在");
            }
        }

        Policeman police =new Policeman();
        //修改警员相关信息
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        //police.setId(uuid);
        String id = policeman.get("id").toString();
        police.setId(id);
        police.setOrgId((Long) policeman.get("orgId"));
        police.setName((String) policeman.get("name"));
        police.setPoliceCode((String) policeman.get("policeCode"));
        police.setSex((String) policeman.get("sex"));
        //police.setIsCreatedAccount((Integer) policeman.get("isCreatedAccount"));
        police.setCabinetBoxId((String) policeman.get("cabinetBoxId"));
        police.setPhone((String) policeman.get("phone"));
        police.setIdCard((String) policeman.get("idCard"));
        police.setPhoto((String) policeman.get("photo"));
        //police.setUpdateUser((String) policeman.get("updateUser"));
        police.setUpdateTime(currentDate);

        policemanMapper.updatePolice(police);

//        //更新缓存中的信息
//        long timestamp = currentDate.getTime(); // 将Date对象转换为long类型的时间戳
//        policeman.put("updateTime",timestamp);
//
//        /**
//         * 更新缓存
//         * */
//        //构建Redis缓存键
//        String redisKey = REDIS_ORG + "true" +'_'+ policeman.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedDataTrue = redisUtils.findCachedData(redisKey);
//        if (cachedDataTrue != null) {
//            //删除之前的缓存信息
//            Iterator<Map<String, Object>> iterator = cachedDataTrue.iterator();
//            while (iterator.hasNext()) {
//                Map<String, Object> oneData = iterator.next();
//                String redisId = oneData.get("id").toString();
//                if (id.equals(redisId)) {
//                    iterator.remove(); // 删除当前循环中的元素
//                    break;
//                }
//            }
//            //将最新的信息加入
//            cachedDataTrue.add(0,policeman);
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, cachedDataTrue);
//        }
//
//
//        //构建Redis缓存键
//        redisKey = REDIS_ORG + "false" +'_'+ policeman.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedDataFalse = redisUtils.findCachedData(redisKey);
//        if (cachedDataFalse != null) {
//            //删除之前的缓存信息
//            Iterator<Map<String, Object>> iterator = cachedDataTrue.iterator();
//            while (iterator.hasNext()) {
//                Map<String, Object> oneData = iterator.next();
//                String redisId = oneData.get("id").toString();
//                if (id.equals(redisId)) {
//                    iterator.remove(); // 删除当前循环中的元素
//                    break;
//                }
//            }
//            //将最新的信息加入
//            cachedDataFalse.add(0,policeman);
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, cachedDataFalse);
//        }

        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllPoliceId(Map<String, Object> msg) {
        //如果组织机构是最高级的，获取所有id
//        if (msg.get("orgId").toString().equals("1369509498032808905")){
//            //构建 Redis 缓存键
//            String redisKey = "getAllPoliceId_"+msg.get("orgId");
//            // 从 Redis 中获取数据
//            List<String> cachedData = redisUtils.findCachedData(redisKey);
//            if (cachedData!=null){
//                return cachedData;
//            }
//            List<String> allPoliceId = policemanMapper.getAllPoliceIdByHighest();
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, allPoliceId);
//            return allPoliceId;
//        }

        //构建 Redis 缓存键
        String redisKey = "getAllPoliceId_"+msg.get("IncludeLowerLevel")+'_'+msg.get("orgId");
        // 从 Redis 中获取数据
        List<String> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData!=null){
            return cachedData;
        }
        List<String> policeId = new ArrayList<>();
        if (msg.get("IncludeLowerLevel").equals("false")){
            policeId = policemanMapper.getAllPoliceId(msg.get("orgId").toString());
        }else if(msg.get("IncludeLowerLevel").equals("true")){
            //查询某组织机构的本级及下级
            List<String> orgIds = getSubIds(msg.get("orgId").toString()); //调用本级及下级的所有组织机构的id
            for (String orgId:orgIds){
                //String redisKey = REDIS_ORG + orgId;
                List<String> allPoliceId = policemanMapper.getAllPoliceId(orgId);
                policeId.addAll(allPoliceId);
            }
        }else {
            //填入的IncludeLowerLevel不正确
            return null;
        }
        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, policeId);
        return policeId;
    }

    //查询某组织机构的所有子机构
    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);//先往List中放入父级id
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }

    @Override
    public ResponseResult deleteFinger(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("fingerId"), "fingerId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String fingerId = msg.get("fingerId").toString();
        policemanMapper.deleteFinger(fingerId);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllPoliceIdByCabinet(Map<String, Object> cabinetId) {
        //根据单警柜id找到所有的箱号id
        List<String> msg = policemanMapper.getAllBoxIdByCabinet(cabinetId.get("cabinetId").toString());
        //遍历所有的箱号id,根据箱号id查询所有的警员信息
        List<String> boxId = new ArrayList<>();
        for (String id:msg){
            policemanMapper.getAllPoliceIdByBoxId(id);
        }
        return boxId;
    }

    @Override
    public ResponseResult addFingerInfo(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("policeId"), "policeId不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("fingerInfo"), "fingerInfo不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //指纹id是自增
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        PoliceFinger finger =new PoliceFinger();

        finger.setPoliceId(msg.get("policeId").toString());
        finger.setName(msg.get("name").toString());
        finger.setFingerInfo(msg.get("fingerInfo").toString());

        finger.setCreateTime(currentDate);
        finger.setUpdateTime(currentDate);
        policeFingerMapper.addFingers(finger);
        return new ResponseResult(HttpStatus.SUCCESS,"操作成功");
    }

    /**
         * @author lxh
         * @description 更新警员的指纹信息
         * @since 2023/7/18 14:21
         * @param
         * @return
         **/
    @Override
    public boolean updateFingerInfo(PoliceFinger req) {
        //警员id,name,指纹信息不能为空
//        PoliceFinger policeFinger = this.queryProduct(req);
//        BeanPlusUtil.copyProperties(req, policeFinger);
//        return this.updateById(policeFinger);
//        try {
//            checkNotBlank(msg.get("policeId"), "policeId不能为空");
//            checkNotBlank(msg.get("name"), "name不能为空");
//            checkNotBlank(msg.get("fingerInfo"), "fingerInfo不能为空");
//        } catch (IllegalArgumentException e) {
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
//        }
//        PoliceFinger policeFinger = new PoliceFinger();
//        policeFinger.setId((Integer) msg.get("id"));
//        policeFinger.setPoliceId((String) msg.get("policeId"));
//        policeFinger.setUpdateTime(DateTimeUtil.getCurrentDateTime());
//        policeFinger.setFingerInfo((String) msg.get("fingerInfo"));
//        policeFinger.setName((String) msg.get("name"));
//        policeFingerMapper.update(policeFinger, new LambdaQueryWrapper<PoliceFinger>()
//                .eq(PoliceFinger::getId, msg.get("id")));
//        return new ResponseResult(HttpStatus.SUCCESS,"操作成功");
        return false;
    }


    /**
     * @author lxh
     * @description 查询警员的指纹信息
     * @since 2023/7/18 14:21
     * @param msg (fingerId)
     * @return
     **/
    @Override
    public ResponseResult searchFingerInfo(Map<String, Object> msg) {
        //警员id不能为空
        try {
            checkNotBlank(msg.get("policeId"), "policeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        List<PoliceFinger> fingerList = policeFingerMapper.selectList(new LambdaQueryWrapper<PoliceFinger>()
                .eq(PoliceFinger::getPoliceId, msg.get("policeId")));
        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",fingerList);
    }

    @Override
    public boolean addFaceInfo(PolicemanReq req) {
        //面部信息为null或者为空
        if (ObjectUtil.isNull(req.getFaceInfo()) || ObjectUtil.isEmpty(req.getFaceInfo())){
            return false;
        }
        Policeman police = getOne(new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(req.getId()),Policeman::getId,req.getId()));
        if (ObjectUtil.isNull(police)){
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        police.setFaceInfo(req.getFaceInfo());
        police.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return policemanService.updateById(police);
    }

    @Override
    public ResponseResult changePoliceState(Map<String, Object> msg) {
        Policeman police =new Policeman();

        try {
            checkNotBlank(msg.get("policeId"), "policeId不能为空");
            checkNotBlank(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        police.setId(msg.get("policeId").toString());
        police.setState((Integer) msg.get("state"));

        policemanMapper.changePoliceState(police);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS);
    }

    public List<Map<String, Object>> getAllPolicemanMsg(Map<String, Object> msg,List<String> allPoliceId) {
        List<Map<String, Object>> allPoliceman = new ArrayList<>();
        // 构建 Redis 缓存键
        String redisKey = REDIS_ORG + msg.get("IncludeLowerLevel").toString() +'_'+ msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            //将Long类型的数据转化为Date
            for (Map<String,Object> one:cachedData){
                Long dataMsg = (Long) one.get("updateTime");
                one.put("updateTime", redisUtils.getDate(dataMsg));
                allPoliceman.add(one);
            }
            return cachedData;
        }
        for (String policeId : allPoliceId) {
            Map<String, Object> policeMsg = policemanMapper.getOnePolice(policeId);
            allPoliceman.add(policeMsg);
        }

        //按照updateTime降序排序
        DateTimeUtil.timeSort(allPoliceman);

        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, allPoliceman);
        return allPoliceman;
    }

    @Override
    public ResponseResult getAllPoliceman(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        List<Map<String, Object>> allPoliceman = new ArrayList<>();

//        // 构建 Redis 缓存键
//        String redisKey = REDIS_ORG + msg.get("IncludeLowerLevel").toString() +'_'+ msg.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
//        if (cachedData != null) {
//            //将Long类型的数据转化为Date
//            for (Map<String,Object> one:cachedData){
//                //如果updateTime的类型为Long
//                Long dataMsg = (Long) one.get("updateTime");
//                one.put("updateTime", redisUtils.getDate(dataMsg));
//                allPoliceman.add(one);
//            }
//            //按照updateTime降序排序
//            //DateTimeUtil.timeSort(allPoliceman);
//            return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allPoliceman);
//        }

        //如果组织机构是浙江省公安厅
        if (msg.get("orgId").toString().equals("1369509498032808905") && msg.get("IncludeLowerLevel").toString().equals("true")){
            allPoliceman = policemanMapper.getAllPolice();
            //将查询结果存入 Redis 中
            //redisUtils.set(redisKey, allPoliceman);
            return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allPoliceman);
        }

        //获取组织机构Id
        List<String> allOrgId =getAllOrgId(msg);
        if (allOrgId.isEmpty()){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"未查询到相关信息");
        }

        //根据获取的组织机构查询警员信息
        allPoliceman = getAllPolicemanByOrg(msg,allOrgId);

        //将查询结果存入 Redis 中
        //redisUtils.set(redisKey, allPoliceman);

        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",allPoliceman);

    }

    private List<Map<String, Object>> getAllPolicemanByOrg(Map<String, Object> msg, List<String> allOrgId) {
        List<Map<String, Object>> allPoliceman = new ArrayList<>();
//        // 构建 Redis 缓存键
//        String redisKey = REDIS_ORG + msg.get("IncludeLowerLevel").toString() +'_'+ msg.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
//        if (cachedData != null) {
//            //将Long类型的数据转化为Date
//            for (Map<String,Object> one:cachedData){
//                Long dataMsg = (Long) one.get("updateTime");
//                one.put("updateTime", redisUtils.getDate(dataMsg));
//                allPoliceman.add(one);
//            }
//            return cachedData;
//        }

//        for (String orgId : allOrgId) {
//            List<Map<String, Object>> policeMsg = policemanMapper.getAllPolicemanByOrg(orgId);
//            allPoliceman.addAll(policeMsg);
//        }
        allPoliceman = policemanMapper.getAllPolicemanByOrgList(allOrgId);

        //按照updateTime降序排序
        //DateTimeUtil.timeSort(allPoliceman);

//        //将查询结果存入 Redis 中
//        redisUtils.set(redisKey, allPoliceman);
        return allPoliceman;
    }

    private List<String> getAllOrgId(Map<String, Object> msg) {
        List<String> allOrg = new ArrayList<>();
        if (msg.get("IncludeLowerLevel").equals("false")){
            allOrg.add((String) msg.get("orgId"));
        }else if(msg.get("IncludeLowerLevel").equals("true")){
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(msg.get("orgId").toString());
        }
        return allOrg;
    }

    @Override
    public ResponseResult getPoliceData(Map<String, Object> cabinetId) {
        try {
            checkNotBlank(cabinetId.get("cabinetId"), "cabinetId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //如果没有找到该单警柜，返回对应信息
        String cabinetMsg = cabinetId.get("cabinetId").toString();
        Map<String, Object> oneCabinet = cabinetMapper.getOneCabinet(cabinetMsg);
        if (oneCabinet.isEmpty()){
            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.NO_DATA,ReturnData.NO_DATA);
        }

        // 构建 Redis 缓存键
        String redisKey = "getPoliceData" + cabinetId.get("cabinetId").toString();
        // 从 Redis 中获取数据
        Map<String, Object> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            //将Long类型的数据转化为Date
//            for (Map<String,Object> one:cachedData){
//                Long dataMsg = (Long) one.get("updateTime");
//                one.put("updateTime", redisUtils.getDate(dataMsg));
//                allPoliceman.add(one);
//            }
            return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,cachedData);
        }

        Map<String, Object> allMsg = new HashMap<>();
        allMsg.put("cabinetName",oneCabinet.get("name"));
        List<Map<String, Object>> allBoxMsg = cabinetBoxMapper.getBoxMsg(cabinetMsg);
        List<Map<String, Object>> policeMsg = new ArrayList<>();
        for (Map<String, Object> boxMsg:allBoxMsg){
            String cabinetBoxId = boxMsg.get("cabinetBoxId").toString();
            List<String> allPoliceIdByBoxId = policemanMapper.getAllPoliceIdByBoxId(cabinetBoxId);
            for(String policeId:allPoliceIdByBoxId){
                Map<String, Object> onePolice = policemanMapper.getOnePolice(policeId);
                List<Map<String, Object>> fingerprints= policeFingerMapper.getFingersByUserId(policeId);
                onePolice.put("fingerMsg",fingerprints);
                policeMsg.add(onePolice);
            }
        }
        allMsg.put("policeList",policeMsg);

        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, allMsg);
        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allMsg);
    }

    /**
         * @author lxh
         * @description 更新人脸信息\删除人脸信息
         * 删除时：传一个null的人脸信息即可
         * @since 2023/7/18 15:02
         * @param
         * @return
         **/
    @Override
    public boolean updateFaceInfo(PolicemanReq req) {
        //警员id不能为空
        if (ObjectUtil.isEmpty(req.getId()) || ObjectUtil.isNull(req.getId())){
            return false;
        }
        LambdaQueryWrapper<Policeman> eq = PolicemanWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getId()), Policeman::getId, req.getId());
        Policeman police = policemanService.getOne(eq);
        police.setFaceInfo(req.getFaceInfo());
        police.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return policemanService.updateById(police);

    }

    /**
         * @author lxh
         * @description 查询人脸信息
         * @since 2023/7/18 15:02
         * @param
         * @return
         **/
    @Override
    public Policeman searchFaceInfo(PolicemanReq req) {
        //警员id不能为空
        if (ObjectUtil.isEmpty(req.getId()) || ObjectUtil.isNull(req.getId())){
            return null;
        }
        LambdaQueryWrapper<Policeman> eq = PolicemanWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getId()), Policeman::getId, req.getId());
        Policeman policeman = policemanService.getOne(eq);
        if (ObjectUtil.isNull(policeman)){
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        return policeman;

    }

    //通过单警柜获取组织机构id,再获取组织机构下的所有警员信息
    @Override
    public List<Policeman> getOrgPoliceman(CabinetReq req) {

        //通过警柜id获取组织机构id
        Cabinet cabinet = cabinetService.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(req.getId()),Cabinet::getId, req.getId()));
        if (ObjectUtil.isNull(cabinet)){
            return null;
        }
        long orgId = cabinet.getOrgId();
        //通过机构id获取机构下所有的警员信息
        List<Policeman> policemenList = policemanService.list(new LambdaQueryWrapper<Policeman>()
                .eq(Policeman::getOrgId, orgId));
        return policemenList;
    }

    private LambdaQueryWrapper<Policeman> PolicemanWrapper(PolicemanReq req) {
        LambdaQueryWrapper<Policeman> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        return wrapper;
    }

}
