package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.CabinetBoxReq;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.exception.enums.PolicemanExceptionEnum;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.*;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class CabinetServiceImpl extends ServiceImpl<CabinetMapper, Cabinet> implements CabinetService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private CabinetMapper cabinetMapper;

    @Resource
    private CabinetBoxMapper cabinetBoxMapper;

    @Resource
    private PolicemanMapper policemanMapper;

    @Resource
    private PubOrgMapper pubOrgMapper;

    @Resource
    private PubOrgService pubOrgService;
    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private PolicemanService policemanService;

    private static final String REDIS_CABINET = "Cabinet_";

    @Override
    public ResponseResult addCabinet(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            //checkNotBlank(msg.get("location"), "location不能为空");
            checkNotBlank(msg.get("num"), "num不能为空");
            checkNotBlank(msg.get("cabinetNum"), "cabinetNum不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        String cabinetNum = msg.get("cabinetNum").toString();

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(msg.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "该组织机构不存在");
        }
        //查询是否有重复的cabinetNum
        Map<String, Object> hashCabinetNum = cabinetMapper.getCabinetByCabinetNum(cabinetNum);
        if (hashCabinetNum != null) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "主柜编号重复");
        }
        Cabinet cabinet = new Cabinet();
        //将警员相关信息添加到警员表
        //生成一个uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        cabinet.setId(uuid);
        cabinet.setCreateTime(currentDate);
        cabinet.setUpdateTime(currentDate);
        cabinet.setOrgId((Long) msg.get("orgId"));
        cabinet.setName((String) msg.get("name"));
        //cabinet.setUpdateUser((String) msg.get("updateUser"));
        cabinet.setLocation((String) msg.get("location"));
        cabinet.setNum((Integer) msg.get("num"));
        cabinet.setCabinetNum(cabinetNum);
        cabinetMapper.addCabinet(cabinet);
        /**
         * 更新缓存
         * */
        //构建Redis缓存键
        String redisKey = REDIS_CABINET + "true" + '_' + msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedDataTrue = redisUtils.findCachedData(redisKey);
        if (cachedDataTrue != null) {
            cachedDataTrue.add(0, msg);
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, cachedDataTrue);
        }
        //构建Redis缓存键
        redisKey = REDIS_CABINET + "false" + '_' + msg.get("orgId").toString();
        // 从 Redis 中获取数据
        List<Map<String, Object>> cachedDataFalse = redisUtils.findCachedData(redisKey);
        if (cachedDataFalse != null) {
            cachedDataFalse.add(0, msg);
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, cachedDataFalse);
        }

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, uuid);
    }

    @Override
    public Map<String, Object> getOneCabinet(String id) {

        return cabinetMapper.getOneCabinet(id);
    }

    @Override
    public ResponseResult deleteCabinet(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("cabinetList"), "cabinetList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        //批量删除操作
        List<Object> cabinetList = (List<Object>) msg.get("cabinetList");
        for (Object cabinetId : cabinetList) {
            cabinetMapper.deleteCabinet(cabinetId.toString());
        }

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    //查询某组织机构的所有子机构
    public List<String> getSubIds(String id) {
        List<String> subIds = new ArrayList<>();
        subIds.add(id);//先往List中放入父级id
        List<String> subMenus = policemanMapper.getChildren(id);//查询该id的子类id
        if (subMenus != null) {
            for (String subMenu : subMenus) {
                subIds.addAll(getSubIds(subMenu));
            }
        }
        return subIds;
    }

    @Override
    public ResponseResult updateCabinet(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("cabinetNum"), "cabinetNum不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        String cabinetNum = msg.get("cabinetNum").toString();

        //查询传入的组织机构id是否存在
        Long onePubOrg = pubOrgMapper.getOnePubOrg(msg.get("orgId").toString());
        if (onePubOrg == null || onePubOrg.equals("")) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "该组织机构不存在");
        }

        //查询是否有重复的cabinetNum
        Map<String, Object> hashCabinetNum = cabinetMapper.getCabinetByCabinetNum(cabinetNum);
        //判断policeCode是否有变动
        String oldCabinetNum = cabinetMapper.getCabinetNumById(msg.get("id").toString());
        if (oldCabinetNum != null && !oldCabinetNum.equals(cabinetNum)) {
            if (hashCabinetNum != null) {
                return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "主柜编号重复");
            }
        }

        Cabinet cabinet = new Cabinet();
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        cabinet.setUpdateTime(currentDate);
        cabinet.setId((String) msg.get("id"));
        cabinet.setCabinetNum((String) msg.get("cabinetNum"));
        cabinet.setName((String) msg.get("name"));
        cabinet.setOrgId((Long) msg.get("orgId"));
        cabinet.setLocation((String) msg.get("location"));
        //cabinet.setUpdateUser((String) msg.get("updateUser"));
        //cabinet.setState((Integer) msg.get("errorState"));
        cabinetMapper.updateCabinet(cabinet);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult changeCabinetState(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("cabinetId"), "cabinetId不能为空");
            checkNotBlank(msg.get("cabinetBoxList"), "cabinetBoxList不能为空");
            List<Map<String, Object>> boxMsg = (List<Map<String, Object>>) msg.get("cabinetBoxList");
            for (Map<String, Object> box : boxMsg) {
                checkNotBlank(box.get("cabinetBoxId"), "cabinetBoxId不能为空");
                checkNotBlank(box.get("state"), "state不能为空");
            }
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        //判断组织机构id是否正确

        CabinetBox cabinetBox = new CabinetBox();
        //读取单警柜id
        cabinetBox.setCabinetId(msg.get("cabinetId").toString());

        //获取cabinetBoxList
        List<Map<String, Object>> boxMsg = (List<Map<String, Object>>) msg.get("cabinetBoxList");
        for (Map<String, Object> box : boxMsg) {
            cabinetBox.setId((String) box.get("cabinetBoxId"));
            cabinetBox.setState((Integer) box.get("state"));
            cabinetBox.setErrorMsg((String) box.get("errorMsg"));
            cabinetBoxMapper.changeCabinetState(cabinetBox);
        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public List<String> getAllCabinetBoxId(String id) {
        List<String> msg = cabinetMapper.getAllCabinetBoxId(id);
        return msg;
    }

    @Override
    public ResponseResult getAllCabinet(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
            checkNotBlank(msg.get("IncludeLowerLevel"), "IncludeLowerLevel不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        List<Map<String, Object>> allCabinet = new ArrayList<>();

//        // 构建 Redis 缓存键
//        String redisKey = REDIS_CABINET;
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
//        List<Map<String, Object>> cabinetList = new ArrayList<>();
//        if (cachedData != null) {
//            cabinetList = cachedData;
//        }else {
//            cabinetList = cabinetMapper.getAllCabinet();
//            redisUtils.set(redisKey, cabinetList);
//        }

//        // 构建 Redis 缓存键
//        String redisKey = REDIS_CABINET + msg.get("IncludeLowerLevel").toString() +'_'+ msg.get("orgId").toString();
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
//        if (cachedData != null) {
//            //将Long类型的数据转化为Date
////            for (Map<String,Object> one:cachedData){
////                Long dataMsg = (Long) one.get("updateTime");
////                one.put("updateTime", redisUtils.getDate(dataMsg));
////                allCabinet.add(one);
////            }
//            return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,cachedData);
//        }

        //如果组织机构是浙江省公安厅
//        if (msg.get("orgId").toString().equals("1369509498032808905") && msg.get("IncludeLowerLevel").toString().equals("true")) {
//            allCabinet = cabinetMapper.getAllCabinet();
//            //将查询结果存入 Redis 中
//            //redisUtils.set(redisKey, allCabinet);
//            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, allCabinet);
//        }

        //获取该组织机构下所有仓库的id
//        List<String> allOrgId = getAllOrgId(msg);
//        if (allOrgId.isEmpty()) {
//            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "未查询到相关信息");
//        }
//
//        allCabinet = getAllCabinetByOrg(msg, allOrgId);

        //List<Map<String, Object>> selectedCabinets = new ArrayList<>(); // 存放匹配到的柜子信息的列表

        // 遍历allOrgId
//        for (String orgId : allOrgId) {
//            // 遍历allCabinet中的每个柜子信息
//            for (Map<String, Object> cabinet : cabinetList) {
//                // 检查柜子信息中的orgId是否与当前遍历的orgId匹配
//                if (cabinet.containsKey("orgId") && cabinet.get("orgId").equals(orgId)) {
//                    // 匹配到了柜子信息，将其添加到selectedCabinets中
//                    selectedCabinets.add(cabinet);
//                }
//            }
//        }


//        String orgId = msg.get("orgId").toString();
//        List<String> allCabinetId =getAllCabinetId(msg);
//        for (String cabinetId :allCabinetId){
//            Map<String, Object> cabinetMsg = cabinetMapper.getOneCabinet(cabinetId);
//            if (cabinetMsg!=null){
//                allCabinet.add(cabinetMsg);
//            }
//        }
//
        //将查询结果存入 Redis 中
        //redisUtils.set(redisKey, allCabinet);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, allCabinet);
    }

    private List<String> getAllOrgId(CabinetReq req, String includeLowerLevel) {
        List<String> allOrg = new ArrayList<>();
        if (includeLowerLevel.equals("false")) {
            allOrg.add(req.getOrgId());
        } else if (includeLowerLevel.equals("true")) {
            //查询某组织机构的本级及下级
            allOrg = pubOrgService.getLowerOrg(req.getOrgId());
        }
        return allOrg;
    }

    private List<Cabinet> getAllCabinetByOrg( List<String> allOrgId) {
        List<Cabinet> allCabinet = new ArrayList<>();
        allCabinet = cabinetMapper.getAllCabinetByOrgList(allOrgId);
        return allCabinet;
    }

    @Override
    public List<String> getAllCabinetId(Map<String, Object> msg) {
        //如果组织机构是最高级的，获取所有id
        if (msg.get("orgId").toString().equals("1369509498032808905")) {
            //构建 Redis 缓存键
            String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
            // 从 Redis 中获取数据
            List<String> cachedData = redisUtils.findCachedData(redisKey);
            if (cachedData != null) {
                return cachedData;
            }
            List<String> allCabinetId = cabinetMapper.getAllCabinetIdByHighest();
            //将查询结果存入 Redis 中
            redisUtils.set(redisKey, allCabinetId);
            return allCabinetId;
        }

        //构建 Redis 缓存键
        String redisKey = "getAllCabinetId_" + msg.get("IncludeLowerLevel") + '_' + msg.get("orgId");
        // 从 Redis 中获取数据
        List<String> cachedData = redisUtils.findCachedData(redisKey);
        if (cachedData != null) {
            return cachedData;
        }
        List<String> cabinetId = new ArrayList<>();
        if (msg.get("IncludeLowerLevel").equals("false")) {
            cabinetId = cabinetMapper.getAllCabinetId(msg.get("orgId").toString());
        } else {
            List<String> orgIds = getSubIds(msg.get("orgId").toString()); //调用本级及下级的所有组织机构的id
            for (String orgId : orgIds) {
                List<String> allPoliceId = cabinetMapper.getAllCabinetId(orgId);
                cabinetId.addAll(allPoliceId);
            }
        }
        //将查询结果存入 Redis 中
        redisUtils.set(redisKey, cabinetId);
        return cabinetId;
    }

    @Override
    public ResponseResult getCabinetDetail(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        String idMsg = msg.get("id").toString();
        Map<String, Object> cabinetMsg = getOneCabinet(idMsg);
        if (cabinetMsg == null) {
            return new ResponseResult(HttpStatus.NO_DATA, ReturnMsg.NO_DATA, ReturnData.NO_DATA);
        }
        List<Map<String, Object>> allBoxMsg = cabinetBoxMapper.getBoxMsg(idMsg);
        cabinetMsg.put("cabinetBoxList", allBoxMsg);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, cabinetMsg);
    }

    public ResponseResult setCabinetInventory(Map<String, Object> msg) {
        String id;
        if (msg.containsKey("locationId") && msg.get("locationId") != "") {
            id = msg.get("locationId").toString();
        } else {
            id = null;
        }
        //统计仓库 装备总数
        cabinetMapper.setCabinetSumInventory(id);
        //统计仓库 装备在库总数
        cabinetMapper.setCabinetInSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetOutSumInventory(id);
        //统计仓库 装备出库总数
        cabinetMapper.setCabinetPriceInventory(id);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }


    /**
     * 添加单警柜
     *
     * @param req
     * @return
     */
    @Transactional
    @Override
    public boolean addCabinetInfo(CabinetReq req) {
        Cabinet cabinet = new Cabinet();
        //查询传入的组织机构id是否存在
        LambdaQueryWrapper<PubOrg> pubOrgWrapper = PubOrgWrapper(Long.parseLong(req.getOrgId()));
        PubOrg puborg = pubOrgService.getOne(pubOrgWrapper);

        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(CabinetExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        LambdaQueryWrapper<Cabinet> wrapper2 = CabinetWrapper(req);
        wrapper2.eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum());
        List<Cabinet> list = this.list(wrapper2);
        if (list.size()>0) {
            //抛出单警柜重复异常
            throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
        }
        BeanPlusUtil.copyProperties(req, cabinet);
        cabinet.setCreateTime(DateTimeUtil.getCurrentDateTime());
        cabinet.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        boolean result = save(cabinet);
        LambdaQueryWrapper<Cabinet> wrapper3 = CabinetWrapper(req);
        wrapper3.eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getCabinetNum())), Cabinet::getCabinetNum, req.getCabinetNum())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getOrgId())), Cabinet::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(ObjectUtil.isNotEmpty(req.getName())), Cabinet::getName, req.getName());
        Cabinet one = getOne(wrapper3);
        for (int i = 1; i <= req.getNum(); i++) {
            CabinetBox cabinetBox = new CabinetBox();
            cabinetBox.setCabinetId(one.getId());
            cabinetBox.setState(1);
            cabinetBox.setNum(i);
            //保存
            cabinetBoxService.save(cabinetBox);
        }
        return result;
    }


    /**
     * 删除单警柜
     *
     * @param req
     * @return
     */
    @Override
    public boolean deleteCabinetInfo(CabinetReq req) {
        //通过单警柜id查询出他的箱门数
        LambdaQueryWrapper<Cabinet> wrapper = CabinetWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getId()), Cabinet::getId, req.getId());
        Cabinet cabinet = this.getOne(wrapper);
        //如果查询不到单警柜抛出异常
        if (ObjectUtil.isEmpty(cabinet)) {
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        //通过单警柜id循环遍历出并删除所有箱门信息
        LambdaQueryWrapper<CabinetBox> eq = CabinetboxWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getCabinetId, req.getId());
        List<CabinetBox> list = cabinetBoxService.list(eq);
        for (CabinetBox cabinetBox: list) {
            cabinetBoxService.removeById(cabinetBox.getId());
        }
        //删除单警柜id
        return this.removeById(cabinet.getId());
    }

    /**
     * 获取单警柜列表
     *通过机构id进行查询
     * @param req 单警柜信息
     * @param includeLowerLevel true：查询本级及下级  false：查询本级
     * @return
     */
    @Override
    public List<Cabinet> getAllCabinetList(CabinetReq req, String includeLowerLevel) {
        List<Cabinet> cabinets = new ArrayList<>();
        //如果组织机构时浙江省公安厅
        if (req.getOrgId().equals("1369509498032808905") && includeLowerLevel.equals("true")) {
            cabinets = cabinetMapper.getAllCabinet();
            return cabinets;
        }
        //分两种情况，如果说是本级及下级（全部）所有的单警柜信息，则incluLowerLevel为true，如果是查询本级的单警柜信息则为false
        if (includeLowerLevel.equals("true") || includeLowerLevel.equals("false")) {
            List<String> allOrgId = getAllOrgId(req, includeLowerLevel);
            if (allOrgId.isEmpty()) {
                //抛出组织机构不存在异常
                throw new ServiceException(CabinetExceptionEnum.PUBORG_NOT_EXIST);
            }
            cabinets = getAllCabinetByOrg(allOrgId);
            return cabinets;
        } else {
            //传递的数据是否正确，不正确抛异常（只接受true、false）
            throw new ServiceException(CabinetExceptionEnum.PARAMETER_ERROR);
        }
    }

    /**
     * 通过单警柜id查询单个单警柜及其箱门信息
     * @param req
     * @return
     */
    @Override
    public Cabinet showOneCabinet(CabinetReq req) {
        LambdaQueryWrapper<Cabinet> eq = CabinetWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getId()), Cabinet::getId, req.getId());
        Cabinet one = getOne(eq);
        if (ObjectUtil.isNull(one)){
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        LambdaQueryWrapper<CabinetBox> eq1 = CabinetboxWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), CabinetBox::getCabinetId, req.getOrgId());
        List<CabinetBox> list = cabinetBoxService.list(eq1);
        one.setList(list);
        return one;
    }

    /**
     * 修改单警柜信息
     * 新增箱数
     * @param req
     * @return
     */
    @Override
    public boolean updateCabinetInfo(CabinetReq req) {
        //查询传入的组织机构id是否存在
        LambdaQueryWrapper<PubOrg> pubOrgwrapper = PubOrgWrapper(Long.parseLong(req.getOrgId()));
        PubOrg puborg = pubOrgService.getOne(pubOrgwrapper);
        if (ObjectUtil.isEmpty(puborg)) {
            //抛出组织机构不存在异常
            throw new ServiceException(CabinetExceptionEnum.PUBORG_NOT_EXIST);
        }
        //查询是否有重复的单警柜编号
        LambdaQueryWrapper<Cabinet> wrapper2 = CabinetWrapper(req);
        wrapper2.eq(ObjectUtil.isNotEmpty(req.getCabinetNum()),Cabinet::getCabinetNum,req.getCabinetNum());
        List<Cabinet> list = this.list(wrapper2);
        if (list.size()>0) {
            //抛出单警柜重复异常
            throw new ServiceException(CabinetExceptionEnum.CABINETID_IS_EXISTS);
        }
        Cabinet cabinet = new Cabinet();
        BeanPlusUtil.copyProperties(req, cabinet);
        //如果新增箱门个数，那么对应的箱门表中也需要插入对应对应数量的箱门记录条数
        LambdaQueryWrapper<Cabinet> eq = CabinetWrapper(req)
                .eq(ObjectUtil.isNotEmpty(req.getOrgId()), Cabinet::getOrgId, req.getOrgId())
                .eq(ObjectUtil.isNotEmpty(req.getCabinetNum()), Cabinet::getCabinetNum, req.getCabinetNum());
        Cabinet cabinet1 = this.getOne(eq);
        Integer oldNum = cabinet1.getNum();
        Integer totalBoxNum = cabinet1.getNum()+req.getNum();
        //循环新增箱数信息
        for (int i= oldNum+1;i<=totalBoxNum;i++){
            CabinetBox cabinetBox = new CabinetBox();
            //箱门id
            String id = UUID.randomUUID().toString();
            cabinetBox.setId(id);
            cabinetBox.setCabinetId(req.getId());
            cabinet.setState(1);
            cabinetBox.setNum(i);
            //保存
            cabinetBoxService.save(cabinetBox);
        }
        //总箱门数就是原来的箱门数+新增的箱门数
        cabinet.setNum(totalBoxNum);
        return this.updateById(cabinet);
    }

    /**
     * 箱门绑定人员
     * 箱门id-->人员
     * @param req
     * @return
     */
    @Override
    public boolean boxBindPolice(CabinetBoxReq req,String policeId) {
        //通过箱门id查询出箱门信息
        CabinetBox one = cabinetBoxService.getOne(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(req.getId()), CabinetBox::getId, req.getId()));
        if (ObjectUtil.isEmpty(one)){
            //箱门id不存在
            throw new ServiceException(CabinetExceptionEnum.CABINETBOX_ISNOT_EXISTS);
        }
        //获取箱门的主柜id
        String cabinetId = one.getCabinetId();
        //通过主柜id获取机构id
        Cabinet one1 = getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(cabinetId), Cabinet::getId,cabinetId));
        if (ObjectUtil.isEmpty(one1)){
            //单警柜不存在异常
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        long orgId = one1.getOrgId();
        //通过警员id获取警员所在的机构id
        Policeman one2 = policemanService.getOne(new LambdaQueryWrapper<Policeman>()
                .eq(ObjectUtil.isNotEmpty(policeId), Policeman::getId, policeId));
        if (ObjectUtil.isEmpty(one2)){
            //警员不存在异常
            throw new ServiceException(PolicemanExceptionEnum.POLICEMAN_NOT_EXIST);
        }
        Long orgId1 = one2.getOrgId();
        //判断两个机构id是否相同，相同则可以绑定，不相同则绑定失败
        if (!orgId1.equals(orgId)){
            return false;
        }
        one2.setCabinetBoxId(one.getId());
        return policemanService.save(one2);
    }


    //查询的各种条件信息
    //单警柜主柜查询条件
    private LambdaQueryWrapper<Cabinet> CabinetWrapper(CabinetReq req) {
        LambdaQueryWrapper<Cabinet> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        return wrapper;
    }

    //箱门的查询条件
    private LambdaQueryWrapper<CabinetBox> CabinetboxWrapper(CabinetReq req) {
        LambdaQueryWrapper<CabinetBox> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        return wrapper;
    }

    //查询机构id是否存在
    private LambdaQueryWrapper<PubOrg> PubOrgWrapper(long orgId) {
        LambdaQueryWrapper<PubOrg> wrapper = new LambdaQueryWrapper<>();
        //查询全部
        if (ObjectUtil.isEmpty(orgId)) {
            return wrapper;
        }
        //查询机构id是否存在
        wrapper.eq(ObjectUtil.isNotEmpty(orgId),PubOrg::getOrgId,orgId);
        return wrapper;
    }
}