package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.CabinetBoxReq;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.utils.ResponseResult;

import java.util.List;
import java.util.Map;

public interface CabinetService extends IService<Cabinet> {

    ResponseResult addCabinet(Map<String, Object> msg);

    ResponseResult deleteCabinet(Map<String, Object> msg);

    List<String> getAllCabinetId(Map<String, Object> orgId);

    Map<String, Object> getOneCabinet(String cabinetId);

    ResponseResult updateCabinet(Map<String, Object> msg);

    ResponseResult changeCabinetState(Map<String, Object> msg);

    List<String> getAllCabinetBoxId(String id);

    ResponseResult getAllCabinet(Map<String, Object> msg);

    ResponseResult getCabinetDetail(Map<String, Object> msg);

    ResponseResult setCabinetInventory(Map<String, Object> msg);

    /**
     * 添加单警柜
     * @param req
     * @return
     */
    boolean addCabinetInfo(CabinetReq req) ;

    /**
     * 删除单警柜
     * @param req
     * @return
     */
    boolean deleteCabinetInfo(CabinetReq req);

    /**
     * 查询单警柜信息，通过组织机构id进行查询
     * @param req
     * @return
     */
    List<Cabinet> getAllCabinetList(CabinetReq req, String includeLowerLevel);


    /**
     * 通过单警柜id进行查询单个单警柜信息及其箱门信息
     * @param req
     * @return
     */
    Cabinet showOneCabinet(CabinetReq req);

    /**
     * 修改单警柜信息
     * @param req
     * @return
     */
    boolean updateCabinetInfo(CabinetReq req);

    /**
     * 箱门绑定人员
     * @param req
     * @return
     */
    boolean boxBindPolice(CabinetBoxReq req,String policeId);
}
