package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.entity.Warehouse;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface WarehouseMapper extends BaseMapper<Warehouse> {

    public int addWarehouse(Warehouse warehouse);

    Map<String, Object> getOneWarehouse(String id);

    void deleteWarehouse(String id);

    void updateWarehouse(Warehouse warehouse);

    List<String> getAllWarehouseId(String orgId);

    void changeWarehouseState(Warehouse warehouse);

    List<String> getAllWarehouseIdByHighest();

    List<Map<String, Object>> getAllWarehouse();

    List<Warehouse> getAllWarehouseByOrgList(List<String> allOrgId);

    void setWarehouseSumInventory(@Param("updateId") String id);

    void setWarehouseInSumInventory(@Param("updateId") String id);

    void setWarehouseOutSumInventory(@Param("updateId") String id);

    void setWarehousePriceInventory(@Param("updateId") String id);
}