package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-SupplierEquipment")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_supplier_type")
public class SupplierEquipment implements Serializable {
    /**
     * 供应商产品ID
     */
    @TableField(value = "id")
    private String id;

    /**
     * 供应商代码
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 产品代码
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 状态，0:启用，1:停用
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 最后更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人ID
     */
    @TableField(value = "update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}