package com.junmp.jyzb.doc;

import com.junmp.jyzb.api.bean.req.ProductTagReq;
import com.junmp.jyzb.api.bean.vo.TagInfoVo;
import com.junmp.jyzb.entity.ProductTag;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 18:10
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Api(value = "生产管理", tags = "生产管理接口")
public interface ProductTagDoc {

    @ApiOperation(value = "更新产品UID", tags = "生产管理接口")
    ApiRes<TagInfoVo> updateUid(ProductTagReq req);


    @ApiOperation(value = "更新产品内容", tags = "生产管理接口")
    ApiRes<TagInfoVo> updateContent(ProductTagReq req);

    @ApiOperation(value = "产品复检", tags = "生产管理接口")
    ApiRes<Boolean> checkTag(ProductTagReq req);

    @ApiOperation(value = "分页接口", tags = "生产管理接口")
    ApiRes<PageResult<ProductTag>> getPage(ProductTagReq req);
}
