package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.api.bean.req.SupplierReq;
import com.junmp.jyzb.entity.Product;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.RequestParam;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Supplier")
@Api(tags = "供应商基础信息模块")
public class SupplierController {
    @Resource
    public SupplierService supplierService;

    @PostMapping("/AddSupplier")
    @ApiOperation("添加供应商")
    public ApiRes<Boolean> addSupplier(@RequestBody @Validated(SupplierReq.add.class) SupplierReq req) {
        return ApiRes.success(supplierService.addSupplier(req));
    }

    @PostMapping("/DeleteSupplier")
    @ApiOperation("删除供应商信息")
    public ApiRes<Boolean> deleteSupplier(@RequestBody @Validated(SupplierReq.delete.class)SupplierReq req) {
        return ApiRes.success(supplierService.deleteSupplier(req));
    }

    @PostMapping("/ShowSupplier")
    @ApiOperation("查询供应商列表")
    public ApiRes<List<Supplier>> showSupplier(SupplierReq req){
        return ApiRes.success(supplierService.showSupplier(req));
    }

//    @PostMapping("/GetOneSupplier")
//    @ApiOperation("查询单个供应商信息")
//    public ResponseResult getOneSupplier(@RequestBody Map<String, Object> msg) {
//        String supplierId = msg.get("supplierId").toString();
//        Map<String, Object> supplierMsg = supplierService.getOneSupplier(supplierId);
//        return new ResponseResult(HttpStatus.SUCCESS,"操作成功",supplierMsg);
//    }

    @PostMapping("/UpdateSupplier")
    @ApiOperation("修改供应商信息")
    public ApiRes<Boolean> updateSupplier(@RequestBody @Validated(SupplierReq.edit.class) SupplierReq req) {
        return ApiRes.success(supplierService.updateSupplier(req));
    }

    @PostMapping("/ChangeSupplierState")
    @ApiOperation("修改供应商状态")
    public ApiRes<Boolean> changeSupplierState(@RequestBody @Validated(SupplierReq.edit.class) SupplierReq req) {
        return ApiRes.success(supplierService.changeSupplierState(req));
    }
}
