package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.EquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.ProductReq;
import com.junmp.jyzb.entity.EquipmentSize;
import com.junmp.jyzb.service.EquipmentSizeService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Size")
@Api(tags = "号型基础信息模块")
public class EquipmentSizeController {
    @Resource
    public EquipmentSizeService equipmentSizeService;

    @PostMapping("/AddSize")
    @ApiOperation("添加号型信息")
    public ApiRes<Boolean> addSize(@RequestBody @Validated(EquipmentSizeReq.add.class) EquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.addSize(req));
    }

    @PostMapping("/DeleteSize")
    @ApiOperation("删除号型信息")
    public ApiRes<Boolean> deleteSize(@RequestBody @Validated(EquipmentSizeReq.delete.class)EquipmentSizeReq req) {
//        ResponseResult returnMsg = equipmentSizeService.deleteSize(msg);
//        return returnMsg;
        return ApiRes.success(equipmentSizeService.deleteSize(req));
    }

    @PostMapping("/GetOneSize")
    @ApiOperation("查询单个号型信息")
    public ApiRes<EquipmentSize> getOneSize(@RequestBody EquipmentSizeReq req) {
        //ResponseResult returnMsg =
        return ApiRes.success(equipmentSizeService.getOneSize(req));
    }

    @PostMapping("/ShowSize")
    @ApiOperation("根据装备类型查询号型")
    public ApiRes<List<EquipmentSize>> getAllSize(@RequestBody EquipmentSizeReq req){
        return ApiRes.success(equipmentSizeService.getAllSize(req));
    }

    @PostMapping("/UpdateSize")
    @ApiOperation("修改号型信息")
    public ApiRes<Boolean> updateSize(@RequestBody @Validated(EquipmentSizeReq.edit.class) EquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.updateSize(req));
    }

    @PostMapping("/ChangeSizeState")
    @ApiOperation("禁用/启用装备号型")
    public ApiRes<Boolean> changeSizeState(@RequestBody @Validated(EquipmentSizeReq.edit.class) EquipmentSizeReq req) {
        return ApiRes.success(equipmentSizeService.changeSizeState(req));
    }

    @PostMapping("/GetSizeDevelop")
    @ApiOperation("获取号型表所有信息(非树表)")
    public ApiRes<EquipmentSize> getSizeDevelop() {
        ResponseResult returnMsg = equipmentSizeService.getSizeDevelop();
        return null;
    }
}
