package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.CabinetBoxReq;
import com.junmp.jyzb.api.bean.req.CabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.service.CabinetBoxService;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnData;
import com.junmp.jyzb.utils.ReturnMsg;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Cabinet")
@Api(tags = "单警柜基础信息模块")
public class CabinetController {
    @Resource
    public CabinetService cabinetService;

    @Resource
    private CabinetBoxService cabinetBoxService;

    @PostMapping("/AddCabinet")
    @ApiOperation("添加单警柜")
    public ResponseResult addCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.addCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteCabinet")
    @ApiOperation("删除单警柜信息")
    public ResponseResult deleteCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.deleteCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/ShowCabinet")
    @ApiOperation("查询单警柜列表")
    public ResponseResult showCabinet(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = cabinetService.getAllCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateCabinet")
    @ApiOperation("修改单警柜信息")
    public ResponseResult updateCabinet(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg =cabinetService.updateCabinet(msg);
        return returnMsg;
    }

    @PostMapping("/ErrorState")
    @ApiOperation("单警柜状态变更")
    public ResponseResult changeCabinetState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = cabinetService.changeCabinetState(msg);
        return returnMsg;
    }

    @PostMapping("/GetCabinetDetail")
    @ApiOperation("查询单警柜及其箱号信息")
    public ResponseResult getCabinetDetail(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = cabinetService.getCabinetDetail(msg);
        return returnMsg;
    }



    @PostMapping("/AddCabinetInfo")
    @ApiOperation("添加单警柜")
    public ApiRes<Boolean> addCabinetInfo(@RequestBody CabinetReq req){
        boolean result = cabinetService.addCabinetInfo(req);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }

    @PostMapping("/DeleteCabinetInfo")
    @ApiOperation("删除单警柜信息")
    public ApiRes<Boolean> deleteCabinetInfo(@RequestBody CabinetReq req) {
        return ApiRes.success(cabinetService.deleteCabinetInfo(req));
    }

    @PostMapping("/ShowCabinetList")
    @ApiOperation("查询单警柜列表")
    public ApiRes<List<Cabinet>> showCabinetList(@RequestBody CabinetReq req,@RequestBody String includeLowerLevel){
        List<Cabinet> allCabinetList = cabinetService.getAllCabinetList(req, includeLowerLevel);
        if (allCabinetList.size()<=0){
            return ApiRes.failure("查询失败,列表为null");
        }
        return ApiRes.success(cabinetService.getAllCabinetList(req,includeLowerLevel));
    }

    //通过单警柜id查询单个箱门及其箱门信息
    @PostMapping("/ShowOneCabinet")
    @ApiOperation("查询单个单警柜及其箱门信息")
    public ApiRes<Cabinet> showOneCabinet(@RequestBody CabinetReq req){
        return ApiRes.success(cabinetService.showOneCabinet(req));
    }

    @PostMapping("/getCabinetBoxList")
    @ApiOperation("通过单警柜id获取箱门列表")
    public ApiRes<List<CabinetBox>> getCabinetBoxList(@RequestBody CabinetReq req){
        return ApiRes.success(cabinetBoxService.getCabinetBoxList(req));
    }


    @PostMapping("/UpdateCabinetInfo")
    @ApiOperation("修改单警柜信息")
    public ApiRes<Boolean> updateCabinetInfo(@RequestBody CabinetReq req) {
        boolean result = cabinetService.updateCabinetInfo(req);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }

    @PostMapping("/boxBindPolice")
    @ApiOperation("箱门绑定人员")
    public ApiRes<Boolean> boxBindPolice(@RequestBody CabinetBoxReq req,@RequestBody String policeId) {
        boolean result = cabinetService.boxBindPolice(req,policeId);
        if (!result){
            return ApiRes.failure("操作失败");
        }
        return ApiRes.success(result);
    }
}