package com.junmp.jyzb.api.bean.req;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.junmp.v2.common.bean.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
public class WarehouseReq extends BaseRequest {
    @NotNull(message = "仓库主键不能为空", groups = {edit.class, delete.class, detail.class})
    private String id;

    private Long departmentId;

    private String name;

    private String location;

    private String phone;

    private String video;

    private Date createTime;

    private Date updateTime;

    private String updateUser;

    @JsonProperty(value = "orgId")
    private Long orgId;

    private Boolean isLocked;

    private Integer sum;

    private Integer outSum;

    private Integer inSum;

    private BigDecimal priceTotal;

    private Integer state;

    private Long orderId;

    @JsonProperty(value = "IncludeLowerLevel")
    private String IncludeLowerLevel;
}