package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class OrgUpdateReq extends BaseRequest {

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = {ValidationApi.edit.class})
    private String statusFlag;
    /**
     * 组织机构列表
     */
    private List<orgIdList> orgIdList;

    private class orgIdList {
        /**
         * 状态
         */
        @NotBlank(message = "组织机构id不能为空", groups = {ValidationApi.edit.class})
        private int id;
    }
}


