package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@EqualsAndHashCode(callSuper = false)
public class InventorySumReq {
    /**
     * 批次主键
     */
    @NotBlank(message = "组织机构号不能为空", groups = {ValidationApi.edit.class})
    private Long orgId;
    /**
     * 位置ID
     */
    private String orgName;
    /**
     * 位置ID
     */
    private String locationId;
    /**
     * 位置信息
     */
    private String locationName;
    /**
     * 类型ID
     */
    private String typeId;
    /**
     * 号型ID
     */
    private String sizeId;

}
