package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.InventoryDto;
import com.junmp.jyzb.api.bean.dto.TjDto.WarrantyDataDto;
import com.junmp.jyzb.api.bean.req.WarrantyReq;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.VieWarrantyGroup;
import com.junmp.jyzb.entity.Warehouse;
import com.junmp.jyzb.mapper.VieWarrantyGroupMapper;
import com.junmp.jyzb.mapper.WarehouseMapper;
import com.junmp.jyzb.service.VieWarrantyGroupService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class VieWarrantyGroupServiceImpl extends ServiceImpl<VieWarrantyGroupMapper, VieWarrantyGroup> implements VieWarrantyGroupService {


    @Override
    public PageResult<WarrantyDataDto> WarrantyData(WarrantyReq req) {
        LambdaQueryWrapper<VieWarrantyGroup> wrapper = createWrapper(req);
        Page<VieWarrantyGroup> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), wrapper);
        List<VieWarrantyGroup> records = page.getRecords();
        long size = list(wrapper).size();
        List<WarrantyDataDto> collect = records.parallelStream()
                .map(vieWarrantyGroup -> {
                    WarrantyDataDto warrantyDataDto = new WarrantyDataDto();
                    BeanPlusUtil.copyProperties(vieWarrantyGroup, warrantyDataDto);
                    return warrantyDataDto;
                }).collect(Collectors.toList());
        Page<WarrantyDataDto> page1 = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        page1.setRecords(collect);
        page1.setTotal(size);
        return PageResultFactory.createPageResult(page1);
    }
    private LambdaQueryWrapper<VieWarrantyGroup> createWrapper(WarrantyReq req) {
        LambdaQueryWrapper<VieWarrantyGroup> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }

        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()), VieWarrantyGroup::getOrgId, req.getOrgId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getSizeId()), VieWarrantyGroup::getSizeId, req.getSizeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getTypeId()), VieWarrantyGroup::getTypeId, req.getTypeId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getWarrantyType()), VieWarrantyGroup::getWarrantyType, req.getWarrantyType());
        if (ObjectUtil.isNotEmpty(req.getWarrantyDays())) {
            int warrantyDays = Integer.parseInt(req.getWarrantyDays());
            wrapper.and(w ->
                    w.ge(VieWarrantyGroup::getDays, -warrantyDays)
                            .le(VieWarrantyGroup::getDays, warrantyDays)
            );
        }
        return wrapper;
    }
}
