package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 温湿度
 * @TableName sys_temp_humidity
 */
@TableName(value ="base_warehouse_dev")
@Data
public class WarehouseDev implements Serializable {
    /**
     * 
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private String orgId;
    /**
     * Ip地址
     */
    @TableField(value = "dev_ip")
    private String devIp;

    /**
     * 端口
     */
    @TableField(value = "dev_port")
    private String devPort;

    /**
     * 名称
     */
    @TableField(value = "dev_name")
    private String devName;

    /**
     * 设备mac
     */
    @TableField(value = "dev_code")
    private String devCode;

    /**
     * 湿度
     */
    @TableField(value = "warehouse_sd")
    private String warehouseSd;

    /**
     * 温度
     */
    @TableField(value = "warehouse_wd")
    private String warehouseWd;

    /**
     * 设定的开关
     */
    @TableField(value = "set_state")
    private String setState;

    /**
     * 状态：0关闭1开启
     */
    @TableField(value = "dev_state")
    private Integer devState;

    /**
     * 设定的温度
     */
    @TableField(value = "set_sd")
    private Integer setSd;

    /**
     * 
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 
     */
    @TableField(value = "update_time")
    private Date updateTime;

    @TableField(exist = false)
    private String orgName;

    @TableField(exist = false)
    private String warehouseName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}