package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-InventorySummary")
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_inventory_summary")
@Data
public class InventorySummary implements Serializable {
    /**
     * 装备汇总id
     */
    @ApiModelProperty(value = "装备汇总id")
    @TableId(type = IdType.AUTO)
    private Long id;

    @TableField(value = "valuekey",updateStrategy = FieldStrategy.IGNORED)
    private String valuekey;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    @TableField("org_id_int")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    @TableField("org_name")
    private String orgName;


    /**
     * 组织机构编码
     */
    @ApiModelProperty(value = "组织机构编码")
    @TableField("org_code")
    private String orgCode;
    /**
     * 装备类型id
     */
    @ApiModelProperty(value = "装备类型id")
    @TableField("type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称")
    @TableField("type_name")
    private String typeName;

    /**
     * 装备号型id
     */
    @ApiModelProperty(value = "装备号型id")
    @TableField("size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @ApiModelProperty(value = "号型名称")
    @TableField("size_name")
    private String sizeName;

    /**
     * 位置类型，0代表仓库，1代表单警柜
     */
    @ApiModelProperty(value = "位置类型，0代表仓库，1代表单警柜")
    @TableField("location_type")
    private String locationType;

    /**
     * 位置信息id
     */
    @ApiModelProperty(value = "位置信息id")
    @TableField("location_id")
    private String locationId;

    /**
     * 位置名称
     */
    @ApiModelProperty(value = "位置名称")
    @TableField("location_name")
    private String locationName;


    /**
     * 库存数量
     */
    @ApiModelProperty(value = "库存数量")
    private Integer number;

    /**
     * 物资单价
     */
    @ApiModelProperty(value = "物资单价")
    @TableField("unit_price")
    private BigDecimal unitPrice;

    /**
     * 总价
     */
    @ApiModelProperty(value = "总价")
    private BigDecimal price;

    /**
     * 在库数
     */
    @ApiModelProperty(value = "在库数")
    @TableField("stock_number")
    private Integer stockNumber;

    @TableField(exist = false)
    private BigDecimal stockNumberPrice;
    /**
     * 出库数量
     */
    @ApiModelProperty(value = "出库数量")
    @TableField("outbound_number")
    private Integer outboundNumber;
    @TableField(exist = false)
    private BigDecimal outboundNumberPrice;
    /**
     * 销毁数量
     */
    @ApiModelProperty(value = "销毁数量")
    @TableField("destruction_number")
    private Integer destructionNumber;
    @TableField(exist = false)
    private BigDecimal destructionNumberPrice;

    /**
     * 销毁金额
     */
    @ApiModelProperty(value = "销毁金额")
    @TableField("destruction_price")
    private BigDecimal destructionPrice;
    /**
     * 过质保数量
     */
    @ApiModelProperty(value = "过质保数量")
    @TableField("expire_number")
    private Integer expireNumber;

    @TableField(exist = false)
    private BigDecimal expireNumberPrice;
    /**
     * 报废数量
     */
    @ApiModelProperty(value = "报废数量")
    @TableField("broken_number")
    private Integer brokenNumber;
    @TableField(exist = false)
    private BigDecimal brokenNumberPrice;
    /**
     * 临近报废数量
     */
    @ApiModelProperty(value = "临近报废数量")
    @TableField("near_broken_number")
    private Integer nearBrokenNumber;

    @TableField("use_count")
    private Integer useCount;

    @TableField("fix_count")
    private Integer fixCount;

    /**
     * 使用中数量（领用和借用）
     */
    @ApiModelProperty(value = "使用中数量（领用和借用）")
    @TableField("use_number")
    private Integer useNumber;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;


    /**
     * 物资阈值
     */
    @ApiModelProperty(value = "物资阈值")
    @TableField("threshold")
    private Integer threshold;

    /**
     * 审核中的报废数量（仅移入报废区的业务单使用）
     */
    @TableField(value = "agent_broken_num")
    private Integer agentBrokenNum;

    //Epc类型（0固定资产1库存物资非固定资产）
    @TableField(value = "property")
    private Integer property;

    @TableField(exist = false)
    private String sizePhoto;

    @TableField(exist = false)
    private String typePhoto;

    private static final long serialVersionUID = 1L;
}