package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum CabinetBoxExceptionEnum implements IExceptionEnum {
    /**
     * 箱子信息不存在，箱门id错误
     */
    CABINETBOX_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"箱子信息不存在，箱门id错误"),

    /**
     * 箱子已经存在
     */
    CABINETBOX_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE,"箱子已经存在，箱门id重复"),

    BOXS_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+ JYZBConstant.JYZB_EXCEPTION_STEP_CODE + 13, "{}"),

    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    CabinetBoxExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}

