package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @TableName("bussiness_order_detail")
    public class OrderDetail implements Serializable {
        @TableId(type = IdType.AUTO)
        private Long id;

        @TableField("order_id")
        private String orderId;

        @TableField("type")
        private String type;

        @TableField("type_id")
        private String typeId;

        @TableField("type_name")
        private String typeName;

        @TableField("size_id")
        private String sizeId;

        @TableField("size_name")
        private String sizeName;

        @TableField("supplier_id")
        private String supplierId;

        @TableField("supplier_name")
        private String supplierName;

        @TableField("warehouse_id")
        private String warehouseId;

        @TableField("warehouse_name")
        private String warehouseName;

        @TableField("plan_num")
        private Integer planNum;

        @TableField("actual_num")
        private Integer actualNum;

        @TableField("modify_quantity")
        private Integer modifyQuantity;

        @TableField("price")
        private BigDecimal price;

        @TableField("total_price")
        private BigDecimal totalPrice;

        @TableField("order_type")
        private String orderType;


        /**
         * 创建时间
         */
        @TableField(value = "create_time", fill = FieldFill.INSERT)
        private Date createTime;

        /**
         * 更新时间
         */
        @TableField(value = "update_time", fill = FieldFill.UPDATE)
        private Date updateTime;

        @TableField("create_user")
        private String createUser;

        @TableField("update_user")
        private String updateUser;


        /**
         * 生产日期
         */
        @TableField("production_date")
        private Date productionDate;

        /**
         * 质保期
         */
        @TableField("warranty_period")
        private Integer warrantyPeriod;

        /**
         * 维保期
         */
        @TableField("maintenance_period")
        private Integer maintenancePeriod;

        @TableField("remark")
        private String remark;
}
