package com.junmp.jyzb.api.bean.req;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * 生产厂商请求实体类
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ManufacturerReq extends BaseRequest {
    /**
     * 生产厂商id
     */
    @NotBlank(message = "生产厂商id不能为空",groups = {edit.class})
    private String id;

    /**
     * 厂商名称
     */
    @NotBlank(message = "生产厂商名称不能为空",groups = {add.class,edit.class})
    private String name;

    /**
     * 厂商短码
     */
    @NotBlank(message = "生产厂商短码不能为空",groups = {add.class})
    private String code;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 状态（1为启用，0为禁用）
     */
    private String state;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人员
     */
    private String createUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 批量删除供应厂商id
     */
    private List<String> deleteList;
}
